<?php
require_once 'db-config.php';

// Set the content type to JSON for the response
header('Content-Type: application/json');

$response_data = [
    'settings' => [],
    'visa_rate' => null,
    'hotel_rates' => ['Makkah' => [], 'Madinah' => []],
    'transport_rates' => [],
    'ziyarat_rates' => []
];

try {
    // 1. Fetch Global Settings (like exchange rate)
    $settings_result = $conn->query("SELECT setting_key, setting_value FROM custom_package_settings");
    if (!$settings_result) throw new Exception("Failed to fetch settings.");
    
    while ($row = $settings_result->fetch_assoc()) {
        $response_data['settings'][$row['setting_key']] = $row['setting_value'];
    }

    // 2. Fetch the single Visa Rate
    $visa_result = $conn->query("SELECT id, description, rate_sar_per_person FROM custom_package_visa_rates LIMIT 1");
    if (!$visa_result) throw new Exception("Failed to fetch visa rate.");
    
    $response_data['visa_rate'] = $visa_result->fetch_assoc();

    // 3. Fetch Hotel Rates and group them by city
    $hotel_result = $conn->query("SELECT id, hotel_name, city, distance_info, notes, rate_quad, rate_trpl, rate_dubl, rate_room_basis FROM custom_package_hotel_rates ORDER BY hotel_name");
    if (!$hotel_result) throw new Exception("Failed to fetch hotel rates.");

    while ($row = $hotel_result->fetch_assoc()) {
        // Convert rate strings to numbers for easier JS calculation
        $row['rate_quad'] = !is_null($row['rate_quad']) ? (float)$row['rate_quad'] : null;
        $row['rate_trpl'] = !is_null($row['rate_trpl']) ? (float)$row['rate_trpl'] : null;
        $row['rate_dubl'] = !is_null($row['rate_dubl']) ? (float)$row['rate_dubl'] : null;
        $row['rate_room_basis'] = !is_null($row['rate_room_basis']) ? (float)$row['rate_room_basis'] : null;
        
        if ($row['city'] === 'Makkah') {
            $response_data['hotel_rates']['Makkah'][] = $row;
        } elseif ($row['city'] === 'Madinah') {
            $response_data['hotel_rates']['Madinah'][] = $row;
        }
    }

    // 4. Fetch Transport Rates
    $transport_result = $conn->query("SELECT id, sector_name, vehicle_type, rate_sar FROM custom_package_transport_rates");
    if (!$transport_result) throw new Exception("Failed to fetch transport rates.");

    while ($row = $transport_result->fetch_assoc()) {
        $response_data['transport_rates'][] = $row;
    }
    
    // 5. Fetch Ziyarat Rates
    $ziyarat_result = $conn->query("SELECT id, city, vehicle_type, rate_sar FROM custom_package_ziyarat_rates");
    if (!$ziyarat_result) throw new Exception("Failed to fetch ziyarat rates.");
    
    while ($row = $ziyarat_result->fetch_assoc()) {
        $response_data['ziyarat_rates'][] = $row;
    }

    // Encode the final array into JSON and output it
    echo json_encode($response_data);

} catch (Exception $e) {
    // If something goes wrong, send a server error status and a JSON error message
    http_response_code(500);
    echo json_encode([
        'error' => 'Failed to fetch package data from the server.',
        'debug_message' => $e->getMessage() // Added for more detailed error info
    ]);
}

// Close the database connection
$conn->close();