<?php
// This ensures session is started, which is needed for user info
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// This gets the filename of the page that is currently being viewed.
$activePage = basename($_SERVER['PHP_SELF']);

// --- LOGIC TO FETCH UNREAD NOTIFICATION COUNT ---
if (!isset($conn) || !$conn) {
    include_once __DIR__ . '/../db-config.php';
}
$unread_notifications_count = 0;
if (isset($conn)) {
    $result = $conn->query("SELECT COUNT(id) as unread_count FROM notifications WHERE is_read = 0");
    if ($result) {
        $unread_notifications_count = (int)$result->fetch_assoc()['unread_count'];
    }
}
?>

<!-- =======================================================
   === STYLES FOR RESPONSIVE SIDEBAR BEHAVIOR ===
   ======================================================= -->
<style>
    @media (max-width: 991.98px) {
        .sidebar-overlay {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.5); z-index: 998;
            opacity: 0; visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }
        .sidebar-overlay.active { opacity: 1; visibility: visible; }
        .sidebar {
            position: fixed; top: 0; left: -260px; /* Start off-screen */
            width: 260px; height: 100%; z-index: 999;
            transition: left 0.3s ease-in-out;
        }
        .sidebar.active { left: 0; }
    }
</style>

<div class="sidebar-overlay" id="sidebar-overlay"></div>

<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <a href="dashboard.php" class="sidebar-logo">
            <img src="../images/logo-2.png" alt="Company Logo">
        </a>
    </div>

    <nav class="sidebar-nav">
        <ul>
            <?php
            // Arrays to group pages together for highlighting the active parent menu
            $bookingPages = ['manage-quick-bookings.php', 'create-quick-booking.php', 'edit-quick-booking.php'];
            $voucherPages = ['manage-vouchers.php', 'create-voucher.php', 'edit-voucher.php', 'view-voucher.php'];
            $invoicingPages = ['manage-invoices.php', 'create-invoice.php', 'edit-invoice.php', 'view-invoice.php', 'ticket-invoices-list.php', 'ticket-invoice-create.php', 'ticket-invoice-edit.php', 'ticket-invoice-view.php'];
            
            // --- UPDATED: Added agent-incentives.php to the accounts group ---
            $accountsPages = ['manage-payments.php', 'add-payment.php', 'edit-payment.php', 'view-receipt.php', 'admin-ledger.php', 'vendor-ledger.php', 'vendor-log.php', 'agent-incentives.php'];
            
            $requestsPages = ['manage-agent-requests.php', 'process-request.php', 'manage-flight-requests.php', 'process-booking.php'];
            $contentPages = ['manage-umrah-packages.php', 'manage-hotels.php', 'hotel-rate-sheets.php', 'manage-hotel-rates.php', 'manage-group-fares.php', 'manage-visa-services.php', 'manage-transport.php', 'manage-hotels-and-visa.php', 'manage-custom-package-rates.php'];
            ?>

            <li class="<?= ($activePage == 'dashboard.php') ? 'active' : '' ?>">
                <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
            </li>

            <li>
                <a href="../index.php" target="_blank"><i class="fas fa-globe"></i> Go to Website</a>
            </li>

            <li class="has-submenu <?= in_array($activePage, $bookingPages) ? 'open active' : '' ?>">
                <a href="#"><i class="fas fa-book"></i> Bookings <i class="submenu-arrow fas fa-angle-right"></i></a>
                <ul class="submenu">
                    <li class="<?= ($activePage == 'manage-quick-bookings.php' || $activePage == 'edit-quick-booking.php') ? 'active' : '' ?>"><a href="manage-quick-bookings.php">Manage Bookings</a></li>
                    <li class="<?= ($activePage == 'create-quick-booking.php') ? 'active' : '' ?>"><a href="create-quick-booking.php">Create Quick Booking</a></li>
                </ul>
            </li>

            <li class="has-submenu <?= in_array($activePage, $voucherPages) ? 'open active' : '' ?>">
                <a href="#"><i class="fas fa-ticket-alt"></i> Vouchers <i class="submenu-arrow fas fa-angle-right"></i></a>
                <ul class="submenu">
                    <li class="<?= ($activePage == 'manage-vouchers.php' || $activePage == 'view-voucher.php') ? 'active' : '' ?>"><a href="manage-vouchers.php">Manage Vouchers</a></li>
                    <li class="<?= ($activePage == 'create-voucher.php' || $activePage == 'edit-voucher.php') ? 'active' : '' ?>"><a href="create-voucher.php">Create New Voucher</a></li>
                </ul>
            </li>

            <li class="has-submenu <?= in_array($activePage, $invoicingPages) ? 'open active' : '' ?>">
                <a href="#"><i class="fas fa-file-invoice-dollar"></i> Invoicing <i class="submenu-arrow fas fa-angle-right"></i></a>
                <ul class="submenu">
                    <li class="<?= ($activePage == 'manage-invoices.php' || $activePage == 'edit-invoice.php' || $activePage == 'view-invoice.php') ? 'active' : '' ?>"><a href="manage-invoices.php">Package Invoices</a></li>
                    <li class="<?= ($activePage == 'ticket-invoices-list.php' || $activePage == 'ticket-invoice-create.php' || $activePage == 'ticket-invoice-edit.php' || $activePage == 'ticket-invoice-view.php') ? 'active' : '' ?>"><a href="ticket-invoices-list.php">Ticket Invoices</a></li>
                </ul>
            </li>

            <li class="has-submenu <?= in_array($activePage, $accountsPages) ? 'open active' : '' ?>">
                <a href="#"><i class="fas fa-calculator"></i> Accounts <i class="submenu-arrow fas fa-angle-right"></i></a>
                <ul class="submenu">
                    <li class="<?= ($activePage == 'manage-payments.php' || $activePage == 'edit-payment.php' || $activePage == 'view-receipt.php') ? 'active' : '' ?>"><a href="manage-payments.php">Manage Payments</a></li>
                    <li class="<?= ($activePage == 'add-payment.php') ? 'active' : '' ?>"><a href="add-payment.php">Add Payment</a></li>
                    <li class="<?= ($activePage == 'admin-ledger.php') ? 'active' : '' ?>"><a href="admin-ledger.php">General Ledger</a></li>
                    <li class="<?= ($activePage == 'vendor-ledger.php') ? 'active' : '' ?>"><a href="vendor-ledger.php">Vendor Ledger</a></li>
                    <li class="<?= ($activePage == 'vendor-log.php') ? 'active' : '' ?>"><a href="vendor-log.php">Vendor Log</a></li>
                    <!-- --- NEW SUBMENU ITEM --- -->
                    <li class="<?= ($activePage == 'agent-incentives.php') ? 'active' : '' ?>"><a href="agent-incentives.php">Agent Incentives</a></li>
                </ul>
            </li>

            <li class="has-submenu <?= in_array($activePage, $requestsPages) ? 'open active' : '' ?>">
                <a href="#"><i class="fas fa-hand-paper"></i> Requests <i class="submenu-arrow fas fa-angle-right"></i></a>
                <ul class="submenu">
                    <li class="<?= ($activePage == 'manage-agent-requests.php' || $activePage == 'process-request.php') ? 'active' : '' ?>"><a href="manage-agent-requests.php">Agent Requests</a></li>
                    <li class="<?= ($activePage == 'manage-flight-requests.php' || $activePage == 'process-booking.php') ? 'active' : '' ?>"><a href="manage-flight-requests.php">Flight Requests</a></li>
                </ul>
            </li>

            <li class="<?= ($activePage == 'view-inquiries.php') ? 'active' : '' ?>">
                <a href="view-inquiries.php"><i class="fas fa-question-circle"></i> Web Inquiries</a>
            </li>
            
            <li class="<?= ($activePage == 'view-custom-inquiries.php') ? 'active' : '' ?>">
                <a href="view-custom-inquiries.php"><i class="fas fa-calculator"></i> Custom Pkg Inquiries</a>
            </li>

            <li class="<?= ($activePage == 'notifications.php') ? 'active' : '' ?>">
                <a href="notifications.php">
                    <i class="fas fa-bell"></i> Notifications
                    <?php if ($unread_notifications_count > 0): ?>
                        <span class="notification-badge"><?= $unread_notifications_count ?></span>
                    <?php endif; ?>
                </a>
            </li>

            <li class="<?= ($activePage == 'manage-users.php') ? 'active' : '' ?>">
                <a href="manage-users.php"><i class="fas fa-users-cog"></i> Manage Users</a>
            </li>

            <li class="<?= ($activePage == 'manage-vendors.php') ? 'active' : '' ?>">
                <a href="manage-vendors.php"><i class="fas fa-store"></i> Manage Vendors</a>
            </li>

            <li class="has-submenu <?= in_array($activePage, $contentPages) ? 'open active' : '' ?>">
                <a href="#"><i class="fas fa-edit"></i> Content <i class="submenu-arrow fas fa-angle-right"></i></a>
                <ul class="submenu">
                    <li class="<?= ($activePage == 'manage-umrah-packages.php') ? 'active' : '' ?>"><a href="manage-umrah-packages.php">Umrah Packages</a></li>
                    <li class="<?= ($activePage == 'manage-hotels.php') ? 'active' : '' ?>"><a href="manage-hotels.php">Website Hotels</a></li>
                    <li class="<?= ($activePage == 'manage-group-fares.php') ? 'active' : '' ?>"><a href="manage-group-fares.php">Airline Groups</a></li>
                    <li class="<?= ($activePage == 'manage-visa-services.php') ? 'active' : '' ?>"><a href="manage-visa-services.php">Visas</a></li>
                    <li class="<?= ($activePage == 'hotel-rate-sheets.php' || $activePage == 'manage-hotel-rates.php') ? 'active' : '' ?>"><a href="hotel-rate-sheets.php">Hotel Rate Sheets</a></li>
                    <li class="<?= ($activePage == 'manage-transport.php') ? 'active' : '' ?>"><a href="manage-transport.php">Transport Rates</a></li>
                    <li class="<?= ($activePage == 'manage-custom-package-rates.php') ? 'active' : '' ?>"><a href="manage-custom-package-rates.php">Custom Pkg Rates</a></li>
                    <li class="<?= ($activePage == 'manage-hotels-and-visa.php') ? 'active' : '' ?>"><a href="manage-hotels-and-visa.php">Old Package Hotels</a></li>
                </ul>
            </li>

            <li>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </li>
        </ul>
    </nav>
</aside>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.getElementById('menu-toggle');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebar-overlay');

    const toggleMobileMenu = () => {
        if (sidebar && overlay) {
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }
    };

    if (menuToggle) menuToggle.addEventListener('click', toggleMobileMenu);
    if (overlay) overlay.addEventListener('click', toggleMobileMenu);

    const submenuToggles = document.querySelectorAll('.sidebar-nav li.has-submenu > a');
    submenuToggles.forEach(toggle => {
        toggle.addEventListener('click', function(event) {
            event.preventDefault();
            const parentLi = this.parentElement;
            
            document.querySelectorAll('.sidebar-nav li.has-submenu.open').forEach(openLi => {
                if (openLi !== parentLi) {
                    openLi.classList.remove('open');
                }
            });
            
            parentLi.classList.toggle('open');
        });
    });
});
</script>