<?php
// This line gets the filename of the page that is currently being viewed.
// For example, on agent-dashboard.php, this will be "agent-dashboard.php".
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!-- ========== AGENT ACCOUNT SIDEBAR (NAVIGATION) ========== -->
<nav class="account-sidebar">
    <div class="sidebar-user-info">
        <div class="user-avatar"><i class="fa-solid fa-user-tie"></i></div>
        <!-- Note: This requires the parent page to have already defined $user_name -->
        <h3><?php echo htmlspecialchars($user_name ?? 'Agent'); ?></h3>
        <p>Agent Account</p>
    </div>
    <hr>
    <ul class="account-nav-list">
      
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-dashboard.php" class="account-nav-link <?php echo ($current_page === 'agent-dashboard.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-home"></i> My Dashboard
            </a>
        </li>
        
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-my-incentives.php" class="account-nav-link <?php echo ($current_page === 'agent-my-incentives.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-hand-holding-dollar"></i> My Incentives
            </a>
        </li>

        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-flights.php" class="account-nav-link <?php echo ($current_page === 'agent-flights.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-plane-departure"></i> My Flights
            </a>
        </li>
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-inquiries.php" class="account-nav-link <?php echo ($current_page === 'agent-inquiries.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-kaaba"></i> My Umrah Inquiries
            </a>
        </li>
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-invoices.php" class="account-nav-link <?php echo ($current_page === 'agent-invoices.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-file"></i> My Invoices
            </a>
        </li>
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-ledger.php" class="account-nav-link <?php echo ($current_page === 'agent-ledger.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-book"></i> My Ledger
            </a>
        </li>

        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="manage-requests.php" class="account-nav-link <?php echo ($current_page === 'manage-requests.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-hand"></i> Requests
            </a>
        </li>

        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-vouchers.php" class="account-nav-link <?php echo ($current_page === 'agent-vouchers.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-ticket"></i> Vouchers
            </a>
        </li>
       
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="agent-edit-profile.php" class="account-nav-link <?php echo ($current_page === 'agent-edit-profile.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-user-pen"></i> Edit Profile
            </a>
        </li>
        <li>
            <!-- The 'active' class is now added dynamically -->
            <a href="edit-company-profile.php" class="account-nav-link <?php echo ($current_page === 'edit-company-profile.php') ? 'active' : ''; ?>">
                <i class="fa-solid fa-building"></i> Company Profile
            </a>
        </li>
        <li>
            <a href="logout.php" class="account-nav-link logout-link">
                <i class="fa-solid fa-arrow-right-from-bracket"></i> Logout
            </a>
        </li>
    </ul>
</nav>