<?php
// We need to start the session to show the correct header state (logged in/out)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Frequently Asked Questions - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <link rel="stylesheet" href="css/faq-style.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- ========== HERO SECTION ========== -->
    <section class="faq-hero-section">
        <div class="hero-content">
            <h1>Help & Support</h1>
            <p>Find answers to your questions and get the help you need to plan your perfect journey.</p>
        </div>
    </section>

    <main class="faq-page-wrapper">
        <div class="container">
            <div class="faq-layout">

                <!-- ========== FAQ NAVIGATION (LEFT) ========== -->
                <aside class="faq-sidebar">
                    <h3>Topics</h3>
                    <a href="#flight-questions" class="faq-topic-link active"><i class="fa-solid fa-plane-up"></i><span>Flights</span></a>
                    <a href="#umrah-questions" class="faq-topic-link"><i class="fa-solid fa-kaaba"></i><span>Umrah</span></a>
                    <a href="#hotel-questions" class="faq-topic-link"><i class="fa-solid fa-hotel"></i><span>Hotels</span></a>
                    <a href="#holiday-questions" class="faq-topic-link"><i class="fa-solid fa-umbrella-beach"></i><span>Holidays</span></a>
                    <a href="#general-questions" class="faq-topic-link"><i class="fa-solid fa-user-gear"></i><span>General & Account</span></a>

                    <div class="sidebar-contact-card">
                        <h4>Can't find an answer?</h4>
                        <p>Our support team is ready to assist you. Get in touch with us directly.</p>
                        <a href="contact-us.php" class="btn-contact">Contact Us</a>
                    </div>
                </aside>

                <!-- ========== FAQ ACCORDION (RIGHT) ========== -->
                <div class="faq-content">

                    <!-- ===== FLIGHTS SECTION ===== -->
                    <h2 id="flight-questions" class="faq-section-title">Flights</h2>
                    <div class="faq-container">
                        <div class="faq-item"><button class="faq-question"><span>How do I book a flight?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>Booking a flight is easy! Simply use the flight search form on our homepage. Enter your departure and destination cities, travel dates, and the number of passengers. Click "Search" to see available flights. Once you find a suitable option, click "Book Now" and follow the steps to the checkout page to enter passenger details and confirm your booking request.</p>
                            </div>
                        </div>
                        <div class="faq-item"><button class="faq-question"><span>Can I change or cancel my booking?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>Yes, but cancellation and change policies vary depending on the airline and the fare type you have purchased. Please contact our support team directly with your booking reference number. Our agents will inform you about the specific policies for your ticket and any applicable fees or penalties.</p>
                            </div>
                        </div>
                        <div class="faq-item"><button class="faq-question"><span>How do I get my ticket after booking?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>Once your booking is confirmed and the payment has been processed, we will issue your e-ticket and send it to the email address you provided during the booking process. You can print this e-ticket or show the digital version at the airport check-in counter.</p>
                            </div>
                        </div>
                        <div class="faq-item"><button class="faq-question"><span>What is a "Group Fare"?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>A Group Fare is a block of seats on a specific flight that we have pre-purchased at a fixed, discounted rate. These are listed in our "Group Flights" section and offer excellent value, but have limited availability and are for specific dates only.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ===== UMRAH SECTION ===== -->
                    <h2 id="umrah-questions" class="faq-section-title">Umrah</h2>
                    <div class="faq-container">
                        <div class="faq-item"><button class="faq-question"><span>What is included in your Umrah packages?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>Our Umrah packages typically include visa processing, return flights, accommodation in Makkah and Madinah, and ground transportation. Specific inclusions may vary by package, so please check the details of your chosen package or contact one of our Umrah specialists for more information.</p>
                            </div>
                        </div>
                        <div class="faq-item"><button class="faq-question"><span>How long does the Umrah visa process take?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>The visa processing time can vary, but it generally takes between 5 to 15 working days after all required documents have been submitted. We recommend booking your package well in advance of your intended travel dates to allow ample time for visa processing.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ===== HOTELS SECTION ===== -->
                    <h2 id="hotel-questions" class="faq-section-title">Hotels</h2>
                    <div class="faq-container">
                        <div class="faq-item"><button class="faq-question"><span>Can I book a hotel without a flight?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>Absolutely! You can book standalone hotel accommodations through our portal. We have a wide range of partner hotels worldwide to suit every budget and preference. Please visit our "Hotels" section to begin your search.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ===== HOLIDAYS SECTION ===== -->
                    <h2 id="holiday-questions" class="faq-section-title">Holidays</h2>
                    <div class="faq-container">
                        <div class="faq-item"><button class="faq-question"><span>Do you offer customized holiday packages?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>Yes, we specialize in creating tailor-made holiday packages. Whether you're looking for a relaxing beach getaway, a cultural city tour, or an adventurous trek, our travel experts can design a personalized itinerary that perfectly matches your interests, budget, and schedule.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ===== GENERAL & ACCOUNT SECTION ===== -->
                    <h2 id="general-questions" class="faq-section-title">General & Account</h2>
                    <div class="faq-container">
                        <div class="faq-item"><button class="faq-question"><span>What payment methods do you accept?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>After you submit a booking request, one of our agents will contact you to confirm the details and process the payment. We accept various payment methods, including bank transfer, credit/debit cards, and mobile payment solutions. Your agent will provide you with all the necessary details.</p>
                            </div>
                        </div>
                        <div class="faq-item"><button class="faq-question"><span>What is the difference between a Customer and an Agent account?</span><i class="fa-solid fa-plus"></i></button>
                            <div class="faq-answer">
                                <p>A <strong>Customer Account</strong> is for individual travelers to manage their personal bookings and profile. An <strong>Agent Account</strong> is designed for travel professionals. It allows agents to manage flight bookings they make on behalf of their clients and provides access to company-specific details and reports.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php include 'floating-icon.php'; ?>
    <?php include 'footer.php'; ?>

    <!-- **UPDATED** JAVASCRIPT for accordion and smooth-scrolling sidebar -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // --- Accordion Logic ---
            const faqQuestions = document.querySelectorAll('.faq-question');
            faqQuestions.forEach(question => {
                question.addEventListener('click', () => {
                    const parentItem = question.parentElement;
                    if (parentItem.classList.contains('active')) {
                        parentItem.classList.remove('active');
                    } else {
                        parentItem.classList.add('active');
                    }
                });
            });

            // --- Sidebar Smooth Scroll & Active State Logic ---
            const topicLinks = document.querySelectorAll('.faq-topic-link');
            const sections = document.querySelectorAll('.faq-section-title');
            const headerOffset = 100; // Adjust this value based on your header's height

            // Smooth scroll for sidebar links
            topicLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    const targetId = this.getAttribute('href');
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        const elementPosition = targetElement.getBoundingClientRect().top;
                        const offsetPosition = elementPosition + window.pageYOffset - headerOffset;

                        window.scrollTo({
                            top: offsetPosition,
                            behavior: "smooth"
                        });
                    }
                });
            });

            // Highlight sidebar link on scroll
            function highlightLinkOnScroll() {
                let fromTop = window.scrollY + headerOffset + 50; // Add a little buffer
                let currentSection = null;

                sections.forEach(section => {
                    if (section.offsetTop <= fromTop) {
                        currentSection = section;
                    }
                });

                topicLinks.forEach(link => {
                    link.classList.remove('active');
                    if (currentSection && link.getAttribute('href') === '#' + currentSection.id) {
                        link.classList.add('active');
                    }
                });
            }

            window.addEventListener('scroll', highlightLinkOnScroll);
            highlightLinkOnScroll(); // Run on page load
        });
    </script>

</body>

</html>