<?php
// flight_row_template.php
// This is a reusable template for displaying a single flight row.
// It expects a $flight variable to be available.

$itinerary = $flight['itineraries'][0];
?>
<div class="flight-row-wrapper" 
     data-price="<?php echo $flight['price']; ?>"
     data-stops="<?php echo $itinerary['stops']; ?>"
     data-airline="<?php echo htmlspecialchars($itinerary['airlineName']); ?>"
     data-departure-ts="<?php echo $itinerary['departureTimestamp']; ?>"
     data-duration="<?php echo ($itinerary['arrivalTimestamp'] - $itinerary['departureTimestamp']); ?>">
    
    <div class="flight-row-main">
        <div class="itinerary-part">
            <div class="airline-details">
                <img src="<?php echo htmlspecialchars($itinerary['airlineLogo']); ?>" alt="">
                <div class="airline-name-info">
                    <span><?php echo htmlspecialchars($itinerary['airlineName']); ?></span>
                    <small><?php echo htmlspecialchars($itinerary['flightNumber']); ?></small>
                </div>
            </div>
            <div class="flight-timing-details">
                <div class="time-iata"><strong><?php echo date('h:i A', strtotime($itinerary['departureTime'])); ?></strong><span><?php echo htmlspecialchars($itinerary['origin']); ?></span></div>
                <div class="duration-stops">
                    <span class="total-duration"><?php echo str_replace(['PT', 'H', 'M'], ['', 'h ', 'm'], $itinerary['duration']); ?></span>
                    <div class="line"></div>
                    <span class="stop-link"><?php echo $itinerary['stops'] > 0 ? $itinerary['stops'] . ' Stop(s)' : 'Nonstop'; ?></span>
                </div>
                <div class="time-iata"><strong><?php echo date('h:i A', strtotime($itinerary['arrivalTime'])); ?></strong><span><?php echo htmlspecialchars($itinerary['destination']); ?></span></div>
            </div>
        </div>

        <?php if (!empty($flight['brandedFare']['name'])): ?>
            <div class="itinerary-part fare-details-wrapper">
                <div class="fare-brand"><?= htmlspecialchars($flight['brandedFare']['name']) ?></div>
                <div class="fare-perks">
                    <?php 
                    $perk_icons = [
                        'SEAT' => 'fa-chair', 'BAG' => 'fa-suitcase', 'REFUND' => 'fa-undo', 'EXCHANGE' => 'fa-exchange-alt'
                    ];
                    foreach ($flight['brandedFare']['included'] as $perk_code): 
                        $perk_text = ucwords(strtolower(str_replace('_', ' ', $perk_code)));
                        $icon_class = 'fa-check-circle';
                        foreach($perk_icons as $key => $icon) {
                            if (strpos($perk_code, $key) !== false) {
                                $icon_class = $icon;
                                break;
                            }
                        }
                    ?>
                        <span><i class="fas <?= $icon_class ?>"></i> <?= htmlspecialchars($perk_text) ?></span>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="flight-row-footer">
        <div><!-- Can add other details here if needed --></div>
        <div class="price-quote-details">
            <a href="checkout.php?flight_id=<?php echo $index; ?>" class="btn-get-quote with-price">
                <small>Book From</small>
                <strong><?php echo htmlspecialchars($flight['currency']); ?> <?php echo number_format($flight['price'], 0); ?></strong>
            </a>
            <button type="button" class="btn-flight-details">Details <i class="fa-solid fa-chevron-down"></i></button>
        </div>
    </div>

    <div class="flight-row-details-content">
        <?php foreach ($flight['itineraries'] as $itinerary_index => $itinerary_detail): ?>
            <h4 style="padding: 1rem 1.5rem 0; margin:0;"><?php echo $tripType === 'return' ? ($itinerary_index === 0 ? 'Outbound' : 'Return') : 'Flight'; ?> Details (<?php echo htmlspecialchars($itinerary_detail['origin'] . ' to ' . $itinerary_detail['destination']); ?>)</h4>
            <?php foreach ($itinerary_detail['segments'] as $segment): ?>
                <div class="detailed-segment">
                    <div class="segment-info">
                        <img src="<?php echo htmlspecialchars($segment['airlineLogo']); ?>">
                        <div>
                            <strong><?php echo htmlspecialchars($segment['airlineName']); ?></strong>
                            <small><?php echo htmlspecialchars($segment['flightNumber']); ?></small>
                            <small class="segment-aircraft"><i class="fas fa-plane"></i> <?php echo htmlspecialchars($segment['aircraft']); ?></small>
                        </div>
                    </div>
                    <div class="detailed-timing">
                        <p><strong><?php echo htmlspecialchars($segment['departure']['time']); ?></strong><br><?php echo htmlspecialchars($segment['departure']['iata']); ?></p>
                        <p class="duration-leg"><i class="fa-solid fa-clock"></i><br><?php echo htmlspecialchars($segment['duration']); ?></p>
                        <p><strong><?php echo htmlspecialchars($segment['arrival']['time']); ?></strong><br><?php echo htmlspecialchars($segment['arrival']['iata']); ?></p>
                    </div>
                </div>
                <?php if (isset($segment['layover'])): ?>
                    <div class="detailed-layover"><i class="fa-solid fa-hourglass-half"></i> Layover of <?php echo htmlspecialchars($segment['layover']['duration']); ?> in <?php echo htmlspecialchars($segment['layover']['airport']); ?></div>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endforeach; ?>
    </div>
</div>