<?php
// We need to start the session on any page that includes the header
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// THIS IS THE CRITICAL FIX: Include the database connection
require_once 'db-config.php'; 

// Fetch featured Umrah packages for a section on the page
$umrah_packages_grid_result = null;
try {
    $sql = "SELECT * FROM umrah_packages WHERE is_active = 1 ORDER BY last_updated DESC LIMIT 3";
    $umrah_packages_grid_result = $conn->query($sql);
} catch (Exception $e) {
    error_log("Failed to fetch Umrah packages for hotels page: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hotel Bookings - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="stylesheet" href="css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        .hotel-list-link {
            color: #d4af37;
            font-weight: 600;
            text-decoration: none;
            border-bottom: 1px dotted #d4af37;
            transition: all 0.2s ease;
        }
        .hotel-list-link:hover {
            color: #fff;
            background-color: #d4af37;
            border-bottom-color: transparent;
        }
        
        .hero-section {
    background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url('./images/bg.jpg');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    position: relative;
    color: white;
    padding-top: 150px;
    padding-bottom: 100px;
    text-align: center;
}

/* ===== MOBILE RESPONSIVE ===== */
@media (max-width: 768px) {
    .hero-section {
        padding-top: 100px;
        padding-bottom: 80px;
        background-position: top center;
    }
}

@media (max-width: 480px) {
    .hero-section {
        padding-top: 80px;
        padding-bottom: 60px;
        background-image: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url('./images/bg.jpg');
        background-position: center top;
        text-align: center;
    }

    .hero-section h1, 
    .hero-section p {
        font-size: 0.9rem;
        line-height: 1.4;
        padding: 0 1rem;
    }
}

    </style>
</head>
<body>

    <?php include 'header.php'; ?>

    <main>
        <section class="hero-section">
            <div class="hero-content">
                <h1>Find Your Perfect Stay</h1>
                <p>From luxury hotels to budget-friendly accommodations, book your ideal hotel with us.</p>
            </div>
            <div class="search-container">
                <div class="tabs-wrapper">
                    <div class="service-tabs">
                        <a href="index.php" class="tab"><i class="fa-solid fa-plane-up"></i> Ticket</a>
                    <a href="group-fares.php" class="tab"><i class="fa-solid fa-users"></i> Groups</a>
                    <a href="umrah-packages.php" class="tab"><i class="fa-solid fa-kaaba"></i> Umrah</a>
                    <a href="hotels.php" class="tab active"><i class="fa-solid fa-hotel"></i> Hotels</a>
                    <a href="visa-services.php" class="tab"><i class="fa-solid fa-passport"></i> Visas</a>
                    <a href="custom-package.php" class="tab"><i class="fa-solid fa-kaaba"></i> Custom Package</a>
                    </div>
                </div>
                <div class="search-form-wrapper">
                    <div class="umrah-welcome-text">
                        <h2>Top Hotel Deals With <strong>Amere Taiba Travel & Tours.</strong></h2>
                        <p>Explore our handpicked selection of top-rated hotels worldwide, offering unmatched prices and exceptional stays.<a href="#all-hotels-anchor" class="hotel-list-link">Star Hotel List</a>.</p>
                        <p class="guarantee-line">Stay in Luxury, Pay Less 🏨</p>
                    </div>
                </div>
            </div>
        </section>

        <?php include 'all-hotels.php'; ?>
        
        <?php include 'floating-icon.php'; ?>
        <?php include 'footer.php'; ?>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const menuToggle = document.querySelector('.menu-toggle');
            const sidebarCloseBtn = document.querySelector('.sidebar-close-btn');
            const mobileSidebar = document.querySelector('.mobile-sidebar');
            const sidebarOverlay = document.querySelector('.sidebar-overlay');
            const body = document.body;

            function openSidebar() {
                mobileSidebar.classList.add('active');
                sidebarOverlay.classList.add('active');
                body.classList.add('sidebar-open');
            }

            function closeSidebar() {
                mobileSidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
                body.classList.remove('open');
            }

            if(menuToggle) menuToggle.addEventListener('click', openSidebar);
            if(sidebarCloseBtn) sidebarCloseBtn.addEventListener('click', closeSidebar);
            if(sidebarOverlay) sidebarOverlay.addEventListener('click', closeSidebar);
        });
    </script>
</body>
</html>