<?php
// --- DATABASE CONNECTION AND ENCODING ---
include_once 'db-config.php';
$conn->set_charset("utf8mb4");

// --- HELPER FUNCTION ---
function e($string) { 
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8'); 
}

// --- VALIDATE & FETCH ALL DATA ---
$voucher_id = (int)($_GET['id'] ?? 0);
if ($voucher_id <= 0) {
    http_response_code(400);
    die("Error: An invalid or missing voucher ID was provided.");
}

$stmt_voucher = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
$stmt_voucher->bind_param("i", $voucher_id);
$stmt_voucher->execute();
$voucher = $stmt_voucher->get_result()->fetch_assoc();

if (!$voucher) {
    http_response_code(404);
    die("Error: The requested voucher could not be found.");
}

$stmt_mutamers = $conn->prepare("SELECT * FROM voucher_mutamers WHERE voucher_id = ? ORDER BY id ASC");
$stmt_mutamers->bind_param("i", $voucher_id);
$stmt_mutamers->execute();
$mutamers = $stmt_mutamers->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt_accommodations = $conn->prepare("SELECT * FROM voucher_accommodations WHERE voucher_id = ? ORDER BY check_in_date ASC");
$stmt_accommodations->bind_param("i", $voucher_id);
$stmt_accommodations->execute();
$accommodations = $stmt_accommodations->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt_flights_pak_ksa = $conn->prepare("SELECT * FROM voucher_flights WHERE voucher_id = ? AND direction = 'Pakistan To KSA'");
$stmt_flights_pak_ksa->bind_param("i", $voucher_id);
$stmt_flights_pak_ksa->execute();
$flights_pak_ksa = $stmt_flights_pak_ksa->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt_flights_ksa_pak = $conn->prepare("SELECT * FROM voucher_flights WHERE voucher_id = ? AND direction = 'KSA To Pakistan'");
$stmt_flights_ksa_pak->bind_param("i", $voucher_id);
$stmt_flights_ksa_pak->execute();
$flights_ksa_pak = $stmt_flights_ksa_pak->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt_voucher->close();
$stmt_mutamers->close();
$stmt_accommodations->close();
$stmt_flights_pak_ksa->close();
$stmt_flights_ksa_pak->close();
$conn->close();

// Calculate totals
$total_pax = count($mutamers);
$total_beds = 0;
foreach($mutamers as $m) {
    if(strtolower($m['bed_required'] ?? 'no') == 'yes') $total_beds++;
}
$total_nights = array_sum(array_column($accommodations, 'nights'));

$urdu_note_text = "ضروری ہدایات
* آپ کا ہوٹل اور پیکج اس دستاویز میں لکھ دیا گیا ہے، اس کے مطابق آپ کو رہائش اور دیگر سہولیات فراہم کی جائیں گی۔
* نشہ آور اشياء شرعاً اور قانوناً ممنوع ہيں، سعودی عرب ميں منشيات لے جانے کی سزا موت ہے۔
* حرمین شریفین کے اندر زمين پر گری پڑی چيز (پرس، موبائل، یا کوئی اور قيمتی چيز) ہرگز نہ اٹھائيں ورنہ آپ مشکل میں پڑ سکتے ہيں۔
* جدہ ایئر پورٹ پر اميگريشن، سعودی وزارت و سعودی کمپنی کے انتظامات ميں 3 سے 5 گھنٹے لگ سکتے ہيں، اس لئے جدہ ایئر پورٹ سے سعودی سم خریديں اور اپنے گھر والوں کو خيريت سے پہنچنے کی اطلاع دے ديں۔
* عمرہ زائرین جدہ ایئر پورٹ سے مکہ جانے کیلئے صرف اپنے ويزہ پر موجود شرکہ کی بسوں میں سفر کريں۔
* سعودیہ میں معتمرین سے پاسپورٹ لینے کی اجازت کسی کو نہیں ہے، لہذا اپنا پاسپورٹ اپنے پاس سنبھال کے رکھیں۔
* پاسپورٹ گم ہونے کی صورت میں آؤٹ پاس اور ٹکٹ کے چارجز معتمر کو دینے ہوں گے۔
* ہوٹل چیک ان ٹائم 4:00 بجے اور ہوٹل چیک آؤٹ ٹائم 2:00 بجے ہے، البتہ مدینے شریف میں کمرہ خالی ہونے اور صفائی کی صورت میں کچھ دیر مزید انتظار کرنا پڑ سکتا ہے۔
* معتمرین واؤچر پر درج شیڈول یا ادارے کے اسٹاف کی طرف سے دیئے گئے روانگی اوقات پر عمل کرنے کے پابند ہوں گے۔
* ہوٹل واؤچر کی 2 عدد کاپياں اپنے ہمراہ لازمی رکھيں۔
* واپسی کی فلائٹ سے 10 گھنٹے قبل مسافر اپنے سامان کے ساتھ رسيپشن پر موجود رہيں۔
* معتمر کو مکہ مکرمہ سے مدینہ شریف، مدینہ شریف سے مکہ مکرمہ اور مکہ مکرمہ سے ایئر پورٹ روانگی سے 24 گھنٹے پہلے اسٹاف کو روانگی شیڈول نوٹ کروانا ہو گا۔ 
* مدینے شریف روانگی کے لئے صبح 7 بجے ہوٹل سے سامان اٹھا کر سٹاف کی طرف سے بس آنے کے بتائے گئے مقام پر آنا ضروری ہو گا۔
* سعودی قانون کے مطابق مکہ سے جدہ ایئر پورٹ روانگی کے لئے 8-10 گھنٹے پہلے ہوٹل چھوڑنا ہو گا۔
* کسی بھی سیکٹر کی ٹرانسپورٹ چھوٹ جانے پر دوبارہ فراہم نہیں کی جائے گی، دوبارہ ٹرانسپورٹ حاصل کرنے کے الگ چارجز ہوں گے۔
* فلائٹ چھوٹ جانے یا آگے بڑھ جانے کی صورت میں ادارہ ذمہ دار نہیں ہو گا، Extra Night کے الگ چارجز معتمر کو دینے ہوں گے۔
* سعودی قوانین اور پالیسی پر مکمل عملدرآمد کرنے کی ذمہ داری معتمرین پر عائد ہو گی۔
* سعودی قانون کے مطابق غير مصنف ہوٹلز میں قيام جرم ہے۔ اس ليئے کمپنی کے تصنيف شدہ ہوٹلز کا استعمال کريں۔
* غير تصنيف شدہ ہوٹلز کے استعمال کی وجہ سے اگر وزارت جرمانہ کرتی ہے تو وہ متعلقہ ایجنٹ سے وصول کیا جائے گا ( اگر کسٹمر ایجنٹ کی طرف سے ملا ہو ) وگرنہ ڈائریکٹ کسٹمر سے وصول کیا جائے گا۔
* کسی بھی پریشانی کی صورت میں معتمرین واؤچر پر درج شدہ سعودی سٹاف کے نمبرز پر رابطہ کریں۔
* نوٹ: مندرجہ بالا ہدایات پر علمدرامد کو یقینی بنائیں، کوتاہی کی صورت میں ہونے والے کسی بھی نقصان کی ذمہ داری معتمرین پر ہو گی۔";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Online Voucher #<?= e($voucher['id']) ?> - RF Travel and Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&family=Tinos:wght@400;700&family=Noto+Naskh+Arabic:wght@400;700&display=swap" rel="stylesheet">
    <style>
        @font-face {
            font-family: 'Jameel Noori Nastaleeq';
            src: url('fonts/Jameel-Noori-Nastaleeq.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        :root { --border-color: #333; --header-bg: #f2f2f2; }
        body { font-family: 'Poppins', sans-serif; background-color: #f0f2f5; margin: 0; padding: 1rem; font-size: 10pt; color: #000; }
        .voucher-container { max-width: 800px; margin: 0 auto; background: #fff; padding: 25px; border: 1px solid var(--border-color); box-shadow: 0 0 15px rgba(0,0,0,0.1); position: relative; }
        .header { display: flex; justify-content: space-between; align-items: flex-start; border-bottom: 2px solid var(--border-color); padding-bottom: 10px; margin-bottom: 15px; }
        .header .logo { max-height: 70px; }
        .header .title { text-align: center; flex-grow: 1; }
        .header h1 { font-family: 'Tinos', serif; margin: 0; font-size: 24pt; font-weight: 700; color: #000; }
        .header p { margin: 5px 0 0; font-size: 11pt; }
        .meta-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 5px 15px; margin-bottom: 15px; }
        .meta-item { display: flex; border: 1px solid var(--border-color); }
        .meta-item .label { background: var(--header-bg); font-weight: bold; padding: 4px 8px; border-right: 1px solid var(--border-color); white-space: nowrap; }
        .meta-item .value { padding: 4px 8px; width: 100%; }
        .section-title { background: var(--border-color); color: #fff; text-align: center; font-weight: bold; padding: 5px; margin: 15px 0 10px; font-size: 11pt; }
        .table-responsive { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid var(--border-color); padding: 5px; text-align: center; white-space: nowrap; }
        thead th { background: var(--header-bg); font-weight: bold; }
        .text-left { text-align: left; }
        .notes-box { margin-top: 15px; padding: 10px; border: 1px solid #000; font-size: 9pt; }
        
        /* *** SPACING FIX *** */
        .urdu-notes-box { 
            margin-top: 15px; 
            padding: 10px; 
            border: 1px solid #000; 
            font-family: 'Jameel Noori Nastaleeq', 'Noto Naskh Arabic', serif; 
            direction: rtl; 
            text-align: right; /* Changed from justify to right */
            font-size: 12pt;
            line-height: 2;
            white-space: pre-wrap; 
        }
        /* *** END FIX *** */

        .footer { text-align: center; margin-top: 1.5rem; color: #6c757d; font-size: 0.8rem; }
        @media (max-width: 600px) {
            body { padding: 0.5rem; font-size: 9pt;}
            .voucher-container { padding: 15px; }
            .header { flex-direction: column; align-items: center; gap: 10px; }
            .meta-grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <div class="voucher-container">
        <header class="header">
            <img src="images/logo-2.png" alt="RF Logo" class="logo">
            <div class="title">
                <h1>RF Travel and Tours</h1>
                <p>Online Hotel Voucher</p>
            </div>
            <div style="width: 70px;"></div> <!-- Spacer -->
        </header>

        <!-- Rest of the HTML content remains the same -->
        <section class="meta-grid">
            <div class="meta-item"><span class="label">Agent:</span><span class="value"><?= e($voucher['shirka_name']) ?></span></div>
            <div class="meta-item"><span class="label">Voucher No:</span><span class="value"><?= e($voucher['id']) ?></span></div>
            <div class="meta-item"><span class="label">Package:</span><span class="value"><?= e($voucher['package_duration_nights']) ?> Nights</span></div>
            <div class="meta-item"><span class="label">Date:</span><span class="value"><?= date('d/m/Y', strtotime($voucher['voucher_date'])) ?></span></div>
            <div class="meta-item"><span class="label">Family Head:</span><span class="value"><?= e($voucher['family_head_name']) ?></span></div>
            <div class="meta-item"><span class="label">Manual No:</span><span class="value"><?= e($voucher['manual_no']) ?></span></div>
        </section>

        <section>
            <div class="section-title">Pilgrims Details</div>
            <div class="table-responsive">
                <table><thead><tr><th>Name</th><th>Passport No</th><th>PAX</th><th>Beds</th><th>Visa No</th><th>PNR</th></tr></thead>
                    <tbody>
                        <?php foreach($mutamers as $mutamer): ?>
                        <tr><td><?= e($mutamer['mutamer_name']) ?></td><td><?= e($mutamer['passport_no']) ?></td><td><?= e($mutamer['pax_type']) ?></td><td><?= e($mutamer['bed_required']) ?></td><td><?= e($mutamer['visa_no']) ?></td><td><?= e($mutamer['pnr_no']) ?></td></tr>
                        <?php endforeach; ?>
                        <tr style="background: var(--header-bg); font-weight: bold;"><td colspan="3" class="text-left">Total PAX: <?= $total_pax ?></td><td colspan="3" class="text-left">Total Beds: <?= $total_beds ?></td></tr>
                    </tbody>
                </table>
            </div>
        </section>

        <section>
            <div class="section-title">Accommodation Details</div>
            <div class="table-responsive">
                <table><thead><tr><th>Hotel</th><th>Confirm No</th><th>City</th><th>Room Type</th><th>Meal Plan</th><th>Check In</th><th>Checkout</th><th>Nights</th></tr></thead>
                    <tbody>
                        <?php foreach($accommodations as $acc): ?>
                        <tr><td><?= e($acc['hotel_name']) ?></td><td><?= e($acc['confirmation_no']) ?></td><td><?= e($acc['city']) ?></td><td><?= e($acc['room_type']) ?></td><td><?= e($acc['meal_plan']) ?></td><td><?= date('d/m/Y', strtotime($acc['check_in_date'])) ?></td><td><?= date('d/m/Y', strtotime($acc['check_out_date'])) ?></td><td><?= e($acc['nights']) ?></td></tr>
                        <?php endforeach; ?>
                        <tr style="background: var(--header-bg); font-weight: bold;"><td colspan="7" class="text-left">Total Nights:</td><td><?= $total_nights ?></td></tr>
                    </tbody>
                </table>
            </div>
        </section>
        
        <?php if (!empty(trim($voucher['transport_description'] ?? ''))): ?>
        <section>
             <div class="section-title">Transport / Services</div>
             <div class="table-responsive">
                <table><thead><tr><th>Name</th><th>Type</th><th>BRN</th></tr></thead>
                    <tbody><tr><td><?= e($voucher['transport_description']) ?></td><td><?= e($voucher['transport_type']) ?></td><td><?= e($voucher['transport_brn']) ?></td></tr></tbody>
                </table>
            </div>
        </section>
        <?php endif; ?>

        <?php if(!empty($flights_pak_ksa) || !empty($flights_ksa_pak)): ?>
        <section>
            <div class="section-title">Flight Details</div>
            <div class="table-responsive">
                <table>
                    <thead><tr><th colspan="4">Pakistan to KSA</th><th colspan="4">KSA to Pakistan</th></tr>
                        <tr><th>Flight</th><th>Sector</th><th>Departure</th><th>Arrival</th><th>Flight</th><th>Sector</th><th>Departure</th><th>Arrival</th></tr></thead>
                    <tbody><tr>
                        <td><?= e($flights_pak_ksa[0]['flight_no'] ?? 'N/A') ?></td><td><?= e($flights_pak_ksa[0]['sector'] ?? 'N/A') ?></td><td><?= isset($flights_pak_ksa[0]['departure_datetime']) ? date('d-M H:i', strtotime($flights_pak_ksa[0]['departure_datetime'])) : 'N/A' ?></td><td><?= isset($flights_pak_ksa[0]['arrival_datetime']) ? date('d-M H:i', strtotime($flights_pak_ksa[0]['arrival_datetime'])) : 'N/A' ?></td>
                        <td><?= e($flights_ksa_pak[0]['flight_no'] ?? 'N/A') ?></td><td><?= e($flights_ksa_pak[0]['sector'] ?? 'N/A') ?></td><td><?= isset($flights_ksa_pak[0]['departure_datetime']) ? date('d-M H:i', strtotime($flights_ksa_pak[0]['departure_datetime'])) : 'N/A' ?></td><td><?= isset($flights_ksa_pak[0]['arrival_datetime']) ? date('d-M H:i', strtotime($flights_ksa_pak[0]['arrival_datetime'])) : 'N/A' ?></td>
                    </tr></tbody>
                </table>
            </div>
        </section>
        <?php endif; ?>

        <div class="notes-box">
            <strong>Note:</strong><br>
            <?php
            $unique_cities = [];
            foreach($accommodations as $acc) { if (!isset($unique_cities[$acc['city']])) { $unique_cities[$acc['city']] = []; } $unique_cities[$acc['city']][] = $acc; }
             foreach($unique_cities as $city => $acc_details_list): 
                foreach($acc_details_list as $acc_details):
            ?>
                <div style="margin-bottom: 5px;">
                    <strong><?= strtoupper(e($city)) ?> HOTEL CONTACT (<?= e($acc_details['hotel_name']) ?>):</strong> 
                    <?= e($acc_details['person_name']) ?> | 
                    Call: <?= e($acc_details['person_call_number']) ?> | 
                    WhatsApp: <?= e($acc_details['person_whatsapp_number']) ?>
                </div>
            <?php 
                endforeach;
            endforeach; 
            ?>
            <?php if (!empty(trim($voucher['transport_description'] ?? ''))): ?>
                <div><strong>Transport Helpline:</strong> <?= e($voucher['transport_helpline_1']) ?> | <?= e($voucher['transport_helpline_2']) ?></div>
            <?php endif; ?>
        </div>
        
        <div class="urdu-notes-box">
             <?= nl2br(e($urdu_note_text)) ?>
        </div>

    </div>
    <footer class="footer">Powered by RF Travel and Tours</footer>
</body>
</html>