<?php
// transport-rates.php
// A public-facing page to display all transport rates with a light, professional design.
include 'db-config.php';

// --- Fetch all transport rates from the database ---
$transport_rates = [];
// MODIFIED: Changed ORDER BY from sector_name ASC to id ASC
$rates_result = $conn->query("SELECT * FROM transport_rates ORDER BY id ASC");
if ($rates_result && $rates_result->num_rows > 0) {
    while ($rate = $rates_result->fetch_assoc()) {
        $transport_rates[] = $rate;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transport Rates - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&family=Oswald:wght@500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        :root {
            --gold: #31a7e2;
            --dark-text: black;
            /* A professional dark blue/gray */
            --light-bg: #f8f9fa;
            /* Light gray page background */
            --white-bg: #ffffff;
            --border-color: #dee2e6;
        }

        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: var(--light-bg);
            color: var(--dark-text);
        }

        .page-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
        }

        /* --- Header with Logos --- */
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0 20px 0;
            border-bottom: 1px solid var(--border-color);
        }

        .logo {
            max-height: 100px;
        }

        /* --- NEW: Styles for the partner logo and its name --- */
        .partner-logo-container {
            display: flex;
            flex-direction: column;
            align-items: center;
        }


        .header-banner img,
        .page-footer img {
            width: 100%;
            display: block;
        }

        .header-banner img {
            border-radius: 8px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            margin-bottom: 20px;
        }

        .partner-name {
            margin-top: 8px;
            /* Space between logo and text */
            font-size: 1.2rem;
            font-weight: 500;
            color: #000000ff;
            /* Muted gray text */
            letter-spacing: 0.5px;
        }

        /* --- Disclaimer Note --- */
        .disclaimer-note {
            background-color: #fff3cd;
            /* Light yellow for info */
            border-left: 4px solid #ffc107;
            /* Gold for info */
            padding: 15px 20px;
            margin: 30px 0;
            border-radius: 0 8px 8px 0;
            display: flex;
            align-items: center;
            font-size: 0.95rem;
            color: #664d03;
        }

        .disclaimer-note i {
            font-size: 1.5rem;
            margin-right: 15px;
        }

        /* --- Main Content & Table Styling --- */
        .content-section {
            background-color: var(--white-bg);
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 4px 25px rgba(0, 0, 0, 0.05);
            margin-top: 30px;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--dark-text);
            text-align: center;
            margin-bottom: 30px;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .rates-table {
            width: 100%;
            min-width: 1100px;
            border-collapse: collapse;
        }

        .rates-table thead th {
            background-color: var(--light-bg);
            padding: 15px;
            font-size: 0.9rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            border-bottom: 2px solid var(--dark-text);
            text-align: center;
        }

        .rates-table thead th:first-child {
            text-align: center;
        }

        .rates-table tbody tr {
            border-bottom: 1px solid var(--border-color);
        }

        .rates-table tbody tr:last-child {
            border-bottom: none;
        }

        .rates-table tbody tr:nth-child(even) {
            background-color: var(--light-bg);
        }

        .rates-table tbody tr:hover {
            background-color: #e9ecef;
        }

        .rates-table td {
            padding: 15px;
            text-align: center;
            vertical-align: middle;
            font-size: 1rem;
        }

        .sector-name-cell {
            text-align: left;
            font-weight: 600;
            color: var(--dark-text);
        }

        .rate-value {
            font-family: 'Oswald', sans-serif;
            font-size: 1.3rem;
            color: #343a40;
        }

        .empty-state {
            padding: 40px;
            text-align: center;
            font-size: 1.1rem;
            color: #6c757d;
        }

        @media (max-width: 768px) {
            .page-container {
                padding: 15px;
            }

            .logo {
                max-height: 50px;
            }

            .section-title {
                font-size: 1.8rem;
            }

            .content-section {
                padding: 20px;
            }
        }
    </style>
</head>

<body>
    <div class="page-container">
        <div class="header-banner">
            <img src="images/22.jpg" alt="RF Travel & Tours Hajj & Umrah Tours">
        </div>
        <header class="page-header">
            <img src="images/logo.png" alt="Company Logo" class="logo">

            <!-- NEW: Container for the partner logo and its name -->
            <div class="partner-logo-container">
                <img src="images/umrahbyismovalogo.png" alt="Partner Logo" class="logo">
                <!-- <span class="partner-name">ISMOVA</span> -->
            </div>
        </header>

        <main>
            <div class="disclaimer-note">
                <i class="fa-solid fa-circle-info"></i>
                <p>All transport rates are quoted in Saudi Riyal (SR) and are subject to change based on seasonal demand.</p>
            </div>

            <div class="content-section">
                <h2 class="section-title">Transportation Rates</h2>

                <div class="table-responsive">
                    <table class="rates-table">
                        <thead>
                            <tr>
                                <th>Sector Name</th>
                                <th>Sedan</th>
                                <th>Starex</th>
                                <th>Staria</th>
                                <th>GMC</th>
                                <th>Hiace</th>
                                <th>Coaster</th>
                                <th>Bus</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($transport_rates)): ?>
                                <?php foreach ($transport_rates as $rate): ?>
                                    <tr>
                                        <td class="sector-name-cell"><?= htmlspecialchars($rate['sector_name']) ?></td>
                                        <!-- UPDATED: Logic to show '-' if rate is 0 -->
                                        <td><span class="rate-value"><?= $rate['sedan_rate'] > 0 ? number_format($rate['sedan_rate']) : '–' ?></span></td>
                                        <td><span class="rate-value"><?= $rate['starex_rate'] > 0 ? number_format($rate['starex_rate']) : '–' ?></span></td>
                                        <td><span class="rate-value"><?= $rate['staria_rate'] > 0 ? number_format($rate['staria_rate']) : '–' ?></span></td>
                                        <td><span class="rate-value"><?= $rate['gmc_rate'] > 0 ? number_format($rate['gmc_rate']) : '–' ?></span></td>
                                        <td><span class="rate-value"><?= $rate['hiace_rate'] > 0 ? number_format($rate['hiace_rate']) : '–' ?></span></td>
                                        <td><span class="rate-value"><?= $rate['coaster_rate'] > 0 ? number_format($rate['coaster_rate']) : '–' ?></span></td>
                                        <td><span class="rate-value"><?= $rate['bus_rate'] > 0 ? number_format($rate['bus_rate']) : '–' ?></span></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="empty-state">No transport rates are currently available. Please check back later.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
</body>

</html>