c:\wamp64\www\hr\testestest.php<?php
session_start();
include_once 'db-config.php'; // Ensure this path is correct

// --- 1. VALIDATE AND GET VOUCHER ID ---
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid Voucher ID.");
}
$voucher_id = (int)$_GET['id'];

// --- 2. FETCH ALL DATA FROM DATABASE ---

// Fetch main voucher details
$stmt = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $voucher_id);
$stmt->execute();
$result = $stmt->get_result();
$voucher = $result->fetch_assoc();

if (!$voucher) {
    die("Voucher not found.");
}

// --- Assuming you have $voucher['user_id'] from your first query ---
$agent_name = '';
$agent_logo_path = '';

if (!empty($voucher['user_id'])) {
    $stmt_agent = $conn->prepare("SELECT name, logo_path FROM users WHERE id = ?");
    $stmt_agent->bind_param("i", $voucher['user_id']);
    $stmt_agent->execute();
    $agent_result = $stmt_agent->get_result()->fetch_assoc();
    if ($agent_result) {
        $agent_name = $agent_result['name'];
        $agent_logo_path = $agent_result['logo_path'];
    }
}

// Fetch accommodations
$stmt_accom = $conn->prepare("SELECT * FROM voucher_accommodations WHERE voucher_id = ? ORDER BY check_in_date ASC");
$stmt_accom->bind_param("i", $voucher_id);
$stmt_accom->execute();
$accommodations = $stmt_accom->get_result()->fetch_all(MYSQLI_ASSOC);

// Fetch mutamers
$stmt_mutamer = $conn->prepare("SELECT * FROM voucher_mutamers WHERE voucher_id = ? ORDER BY id ASC");
$stmt_mutamer->bind_param("i", $voucher_id);
$stmt_mutamer->execute();
$mutamers = $stmt_mutamer->get_result()->fetch_all(MYSQLI_ASSOC);

// Fetch flights and separate them
$stmt_flight = $conn->prepare("SELECT * FROM voucher_flights WHERE voucher_id = ?");
$stmt_flight->bind_param("i", $voucher_id);
$stmt_flight->execute();
$flights_data = $stmt_flight->get_result()->fetch_all(MYSQLI_ASSOC);

$departure_flight = null;
$arrival_flight = null;
foreach ($flights_data as $flight) {
    if ($flight['direction'] == 'Pakistan To KSA') {
        $departure_flight = $flight;
    } else if ($flight['direction'] == 'KSA To Pakistan') {
        $arrival_flight = $flight;
    }
}

// Helper function for safe output
function e($string)
{
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>View Voucher #<?= e($voucher['id']) ?></title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Baloo+Bhaijaan+2:wght@700&family=Noto+Nastaliq+Urdu:wght@400;700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Rubik+Mono+One&display=swap" rel="stylesheet">

    <style>
        body {
            background-color: #f0f0f0;
            font-family: 'Roboto', sans-serif;
            font-size: 14px;

        }

        .voucher-container {
            width: 850px;
            margin: 20px auto;
            padding: 30px;
            position: relative;
            /* This is crucial for positioning the overlay */
            border: 1px solid #ccc;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            z-index: 0;
            /* Set a base stacking context */

            /* --- BOTTOM LAYER: The texture background --- */
            background-image: url('./images/background-texture.jpg');
            background-size: cover;
            background-position: center;
            background-color: #fff;
            /* Fallback */
        }


        .voucher-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;

            /* --- TOP LAYER: The overlay image --- */
            background-image: url('images/ibn-e-yousuf-2.png');
            background-size: 1100px auto;
            /* Adjust size as needed */
            background-position: center center;
            background-repeat: no-repeat;

            /* --- THE "DULL" EFFECT --- */
            /* Adjust this value between 0 (invisible) and 1 (fully visible) */
            opacity: 0.15;

            /* This pushes the overlay behind the content (text, tables, etc.) */
            z-index: 1;
        }



        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-40deg);
            font-size: 120px;
            font-weight: 700;
            /* color: rgba(0, 128, 0, 0.4);  <-- REMOVE THIS LINE */
            z-index: 1000;
            pointer-events: none;
            text-transform: uppercase;
        }

        .content-wrapper {
            position: relative;
            z-index: 2;
        }


        .voucher-header {
            display: flex;
            justify-content: space-between;
            align-items: center;

            position: relative;
            min-height: 120px;
            /* --- FONT ADDED HERE --- */
            font-family: Cambria, Georgia, 'Times New Roman', serif;
        }

        /* --- Left Column --- */
        .header-left {
            flex: 1;
            /* Takes up space on the left */
            display: flex;
            align-items: center;
            gap: 15px;
            min-width: 250px;
        }

        .header-left .agent-logo {

            max-height: 100px;
            display: block;

            flex-shrink: 0;
        }

        .agent-name {
            font-size: 18px;
            max-width: 200px;
            color: #004d30;

            font-weight: bold;
            display: block;
            margin-bottom: 5px;
        }

        .voucher-info {
            font-size: 12px;
            line-height: 1.4;
            text-align: left;
        }

        /* --- Center Column (Absolutely Centered) --- */
        .header-center {
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            width: auto;
        }

        .header-center img {
            max-height: 140px;
            display: block;
        }

        /* --- Right Column --- */
        .header-right {
            flex: 1;
            /* Takes up space on the right */
            text-align: right;
            min-width: 150px;
        }

        .shirka-block {
            display: inline-block;
            text-align: center;
            vertical-align: top;
        }

        .shirka-block img {

            max-height: 100px;
            display: block;
            margin: 0 auto;
        }

        .shirka-name {
            display: block;
            margin-top: 5px;
            font-size: 14px;
            font-weight: bold;
            color: #004d30;
        }

        /* --- Keep these styles as they are --- */
        .family-head-container {
            margin-top: 15px;
            padding: 8px 0;
            border-top: 3px double #999;
            border-bottom: 3px double #999;
            color: #004d30;
            font-family: Cambria, Georgia, 'Times New Roman', serif;
        }

        .thank-you-text {
            font-size: 13px;
            padding-left: 15px;
            margin-bottom: 5px;
        }

        /* --- UPDATE THIS SECTION --- */
        .family-details-bar {
            /* KEY: Make this the positioning container for its children */
            position: relative;
            padding: 0 15px;
            /* Give it a height so the vertical alignment works */
            min-height: 35px;
        }

        /* NEW: Common style for all three items inside the bar */
        .family-details-bar>div {
            /* KEY: Take the elements out of the normal layout flow */
            position: absolute;
            /* KEY: Vertically center all items */
            top: 50%;
            transform: translateY(-50%);
        }

        /* NEW: Style and position the Booking Reference in the center */
        .booking-ref {
            font-size: 22px;
            font-weight: 700;
            width: 100%;
            /* Make it take the full width */
            text-align: center;
            /* Center the text inside */
            /* Position it in the exact middle. The transform is already handled above. */
            left: 0;
        }

        /* NEW: Style and position the Family Head on the left */
        .family-head-name {
            font-size: 18;
            font-weight: 700;
            /* Position it on the far left, respecting parent padding */
            left: 15px;
        }

        /* NEW: Style and position the Manual No on the right */
        .manual-no {
            font-size: 15px;
            font-weight: 700;
            /* Position it on the far right, respecting parent padding */
            right: 15px;
        }

        .section-title {
            background-color: black;
            color: white;
            text-align: center;
            font-size: 32px;
            font-weight: 900;
            /* This font is already very bold, 400 is correct */
            padding: 2px 0;
            margin: 10px auto 0 auto;
            width: 60%;
            border-radius: 25px 25px 0px 0px;
            border: 2px solid #f7b731;

            /* --- FONT CHANGED HERE --- */
            font-family: 'Anton', sans-serif;

            letter-spacing: 1px;
        }

        .mutamers-table .mutamer-name {
            text-align: left;

        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }


        /* --- Base styles for BOTH headers and cells --- */
        .data-table th,
        .data-table td {
            padding: 8px;
            text-align: center;
            vertical-align: middle;
        }

        /* --- Styles JUST for the table headers (thead) --- */
        .data-table thead th {
            border: 1px solid black;

            background-color: #f7b731;
            color: #004225;
            font-weight: 700;
            font-size: 13px;
            font-family: Cambria, Georgia, 'Times New Roman', serif;
        }

        /* --- Styles JUST for the main data cells (tbody) --- */
        .data-table tbody td {
            font-size: 12px;
            font-weight: bold;
            /* A normal weight is better for readability */
            font-family: Cambria, Georgia, 'Times New Roman', serif;
            font-style: italic;
        }

        /* Special styling for the contact info row's text */
        .contact-info-row td {
            font-size: 11px;
            font-style: normal;
            /* Contact info probably shouldn't be italic */
            font-weight: bold;
            color: #333;
            padding: 6px;
            /* A little less padding */
        }


        /* --- ZEBRA STRIPING FOR ROW PAIRS --- */

        /* Target the FIRST PAIR of rows (1st and 2nd rows in every group of 4) */
        .data-table tbody tr:nth-child(4n-3),
        .data-table tbody tr:nth-child(4n-2) {
            background-color: #ffffff;
            /* White */
        }

        /* Target the SECOND PAIR of rows (3rd and 4th rows in every group of 4) */
        .data-table tbody tr:nth-child(4n-1),
        .data-table tbody tr:nth-child(4n) {
            background-color: #e7e7e7ff;
            /* Light Grey */
        }

        /* --- (Optional but Recommended) Add a hover effect for the PAIR --- */
        .data-table tbody tr:nth-child(odd):hover,
        .data-table tbody tr:nth-child(odd):hover+tr {
            background-color: #e9e9e9;
            /* A slightly darker grey on hover */
        }


        /* ============================================== */
        /* === ZEBRA-STRIPING FOR STANDARD TABLES ======= */
        /* ============================================== */

        .mutamers-table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
            /* Light Grey */
            border-top: 2px solid #555;
            border-bottom: 2px solid #555;
        }

        .mutamers-table tbody tr:nth-child(odd) {
            background-color: #ffffff;
            /* White */
        }

        .mutamers-table tbody tr:hover {
            background-color: #e9e9e9;
        }

        .data-table thead th {
            background-color: #f7b731;
            color: #004225;
            font-weight: 700;

            /* --- FONT ADDED HERE --- */
            font-family: Cambria, Georgia, 'Times New Roman', serif;
        }


        /* --- Keep your original TD style --- */
        .contact-info-row td {
            font-size: 11px;
            padding: 4px;
            /* We can adjust padding if needed */
            border-top: 2px solid #555;
            border-bottom: 2px solid #555;
            background-color: #f7f7f7;
            color: #c00;
        }


        /* --- Add these new Flexbox styles --- */

        /* 1. Make the wrapper a flex container */
        .contact-wrapper {
            display: flex;
            align-items: center;
            /* Vertically aligns items if they have different heights */
            width: 100%;
        }

        /* 2. Style the left-aligned city info */
        .city-info {
            /* This part will take up only the space it needs */
            text-align: left;
            white-space: nowrap;
            /* Prevents this text from wrapping */
            padding-right: 20px;
            /* Adds some space between the two sections */
        }

        /* 3. Style the centered contact details */
        .contact-details {
            /* This part will grow to fill ALL remaining space */
            flex-grow: 1;
            /* THEN, the text inside it will be centered */
            text-align: center;
        }


        .transport-table td {
            padding: 8px;
        }

        /* 1. Style the parent cell (TD) and make it a positioning context */
        .transport-helpline td {
            background: #f3f3f3;
            font-weight: bold;
            color: #c00;
            padding: 5px;
            font-size: 11px;
            border-top: 2px solid #555;

            /* KEY: Center the main text (the numbers) across the full width */
            text-align: center;

            /* KEY: Make this the container for the absolutely positioned label */
            position: relative;
        }

        /* 2. Style the numbers span (it doesn't need much) */
        .transport-helpline .helpline-numbers {
            /* No special styles needed, it inherits the text-align:center from the <td> */
        }

        /* 3. Style the label as an absolute overlay */
        .transport-helpline .helpline-label {
            /* KEY: Take the label out of the normal layout flow */
            position: absolute;

            /* Position it on the far left */
            left: 5px;
            /* Aligns with the parent's padding */

            /* Position it vertically in the middle */
            top: 50%;
            transform: translateY(-50%);

            /* To prevent centered text from showing underneath the label */
            background-color: #f3f3f3;
            padding-right: 10px;
            /* Adds some breathing room */
        }

        /* Main container for positioning context */
        .flights-section {
            position: relative;
            margin-top: 5px;
            min-height: 65px;
        }

        /* Wrapper for the two flight boxes */
        .flight-boxes-wrapper {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 15px;
        }

        /* Overall container for a single flight box */
        .flight-box {
            flex: 1;
            min-width: 350px;
            border: 1px solid #000;

            /* --- FONT AND STYLE APPLIED HERE FOR ALL CHILDREN --- */
            font-family: Cambria, Georgia, 'Times New Roman', serif;
            font-style: italic;
        }

        /* The main orange title bar (e.g., "Departure") */
        .flight-box-title {
            background-color: #f7b731;
            padding: 4px;
            color: #004225;
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            border-bottom: 1px solid #000;
            /* It will inherit Cambria and italic from .flight-box */
        }

        /* This is the container for the grid below the title */
        .flight-grid {
            background-color: #fff;
        }

        /* Common style for BOTH the header and details rows */
        .flight-header-row,
        .flight-details-row {
            display: flex;
        }

        /* Common style for ALL cells inside the grid */
        .flight-header-row>div,
        .flight-details-row>div {
            flex: 1;
            text-align: center;
            padding: 1px;
        }

        /* Specific styles for the HEADER row ("Flight", "Sector", etc.) */
        .flight-header-row {
            color: #000;
            font-size: 12px;
            font-weight: bold;
            border-bottom: 3px double #000;
        }

        /* Specific styles for the DATA row ("ER-401", etc.) */
        .flight-details-row {
            color: #000;
            font-size: 12px;
            font-weight: bold;
            border-bottom: 3px double #000;
        }


        /* --- UNCHANGED QR CODE STYLES --- */
        .qr-code-box {
            position: absolute;
            right: 0;
            top: 50%;
            transform: translateY(-50%);
            text-align: center;
        }

        .qr-code-box img {
            width: 50px;
            height: 50px;
            border: 1px solid #004225;
            padding: 4px;
            background-color: #fff;
        }

        /* Urdu Notes Section */
        .urdu-notes-section {
            direction: rtl;
            font-family: 'Noto Nastaliq Urdu', sans-serif;
            font-size: 11px;
            line-height: 1.5;
            margin-top: 20px;
            padding: 10px;
            border-top: 1px solid #ccc;
            width: 100%;
            box-sizing: border-box;
        }

        /* RESTORED: Signature Block */
        .signature-block {
            margin-top: 0px;
            padding-top: 5px;
            font-size: 13px;
            line-height: 1.5;
        }

        /* Footer Logo Banner */
        .airline-logo-banner {
            margin-top: 0px;
            padding: 10px 0;
            border-top: 4px solid #004225;
            border-bottom: 4px solid #004225;
            background-image: url('./images/background-texture.jpg');
            background-size: cover;
            background-position: center;
            display: flex;
            justify-content: space-around;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
        }

        .airline-logo-banner img {
            max-height: 35px;
            max-width: 75px;
            object-fit: contain;
        }

        .print-button-container {
            text-align: center;
            padding: 15px 0;
        }

        /* --- CORRECTED CSS FOR PRINTING --- */
        @media print {

            /* This is the most important rule: it controls the printed page itself */
            @page {
                size: auto;
                /* Let the content dictate the size */
                margin: 0mm;
                /* Forcefully remove all browser-imposed margins */
            }

            /* Hide elements not meant for printing */
            .no-print {
                display: none !important;
            }

            /* Reset the main elements for a clean slate */
            body,
            html {
                background: #fff !important;
                /* White background for printing */
                margin: 0 !important;
                padding: 0 !important;
            }

            /* Ensure the voucher container is the only thing visible and properly formatted */
            .voucher-container {
                /* Remove screen styling */
                box-shadow: none !important;
                border: none !important;

                /* CRUCIAL: Remove the margin that centers it on screen */
                margin: 0 !important;

                /* Keep the original width and padding to maintain the layout perfectly */
                width: 850px;
                padding: 30px;
            }
        }
    </style>
</head>

<body>
    <!-- Added .no-print class to this container -->
    <div class="print-button-container no-print">
        <button onclick="window.print()" style="padding: 10px 25px; font-size: 16px; cursor: pointer;">Print Voucher</button>
    </div>

    <div class="voucher-container">

        <?php
        // Determine the watermark color based on the voucher status
        if ($voucher['status'] == 'Tentative') {
            $watermark_color = 'rgba(255, 0, 0, 0.15)'; // A semi-transparent red
        } elseif ($voucher['status'] == 'Confirmed') {
            $watermark_color = 'rgba(0, 128, 0, 0.15)'; // A semi-transparent green
        } else {
            $watermark_color = 'rgba(128, 128, 128, 0.15)'; // A neutral gray for any other status
        }
        ?>

        <!-- The Watermark Div with a dynamic inline style for the color -->
        <div class="watermark" style="color: <?= $watermark_color; ?>;">
            <?= e($voucher['status']) ?>
        </div>
        <div class="content-wrapper">

            <!-- Header -->
            <div class="voucher-header">
                <!-- LEFT: Now contains agent logo, name, and voucher details -->
                <div class="header-left">
                    <?php if (!empty($agent_logo_path)): ?>
                        <img src="./uploads/logos/<?= htmlspecialchars($agent_logo_path) ?>" alt="Agent Logo" class="agent-logo">
                    <?php endif; ?>

                    <div class="agent-and-voucher-details">
                        <?php if (!empty($agent_name)): ?>
                            <strong class="agent-name"><?= e($agent_name) ?></strong>
                        <?php endif; ?>

                        <div class="voucher-info">
                            <strong>Voucher:</strong> <?= e($voucher['voucher_date'] ? date('d-M-Y', strtotime($voucher['voucher_date'])) : '') ?><br>
                            <strong>Package:</strong> <?= e($voucher['package_type']) ?> <strong>(<?= e($voucher['package_duration_nights']) ?>-N)</strong><br>
                            <strong>Pax:</strong> <?= e($voucher['pax_summary']) ?>
                        </div>
                    </div>
                </div>

                <!-- CENTER: Now only contains the main company logo -->
                <div class="header-center">
                    <img src="images/logo.png" alt="RF Travel & Tours Logo">
                </div>

                <!-- RIGHT: Unchanged, contains Shirka logo -->
                <!-- RIGHT: Contains Shirka logo and name -->
                <div class="header-right">
                    <?php
                    // --- STEP 1: Define the correct full relative path for the file check ---
                    $full_relative_path = 'admin/' . $voucher['shirka_logo_path'];

                    // Only show this block if there's a logo or a name
                    if (($voucher['shirka_logo_path'] && file_exists($full_relative_path)) || !empty($voucher['shirka_name'])):
                    ?>

                        <div class="shirka-block">
                            <?php if ($voucher['shirka_logo_path'] && file_exists($full_relative_path)): ?>

                                <!-- STEP 2: Prepend 'admin/' to the path for the image URL -->
                                <img src="<?= e($full_relative_path) ?>" alt="Shirka Logo">

                            <?php endif; ?>

                            <?php if (!empty($voucher['shirka_name'])): ?>
                                <strong class="shirka-name"><?= e($voucher['shirka_name']) ?></strong>
                            <?php endif; ?>
                        </div>

                    <?php endif; ?>
                </div>
            </div>



            <!-- Family Head -->
            <!-- Family Head -->
            <div class="family-head-container">
                <div class="thank-you-text">Thank You for your interest on RF Travel & Tours</div>
                <div class="family-details-bar">
                    <!-- Element to be centered -->
                    <div class="booking-ref">
                        | <strong><?= e($voucher['booking_ref_no']) ?></strong> |
                    </div>

                    <!-- Element to be on the left -->
                    <div class="family-head-name">
                        Family Head: <strong><?= strtoupper(e($voucher['family_head_name'])) ?></strong>
                    </div>

                    <!-- Element to be on the right -->
                    <div class="manual-no">
                        Manual No: <strong><?= e($voucher['manual_no']) ?></strong>
                    </div>
                </div>
            </div>

            <!-- Accommodation -->
            <h2 class="section-title">Accommodation</h2>
            <table class="data-table accommodation-table">
                <thead>
                    <tr>
                        <th>City</th>
                        <th>Room Type</th>
                        <th>Check-Inn</th>
                        <th>Nights</th>
                        <th>Check-out</th>
                        <th>View</th>
                        <th>Meal</th>
                        <th>Confirmation #</th>
                        <th>Hotels</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($accommodations as $accom): ?>
                        <tr>
                            <td><?= e($accom['city']) ?></td>
                            <td><?= e($accom['room_type']) ?></td>
                            <td><?= e($accom['check_in_date'] ? date('d-m-Y', strtotime($accom['check_in_date'])) : '') ?></td>
                            <td><?= e(str_pad($accom['nights'], 2, '0', STR_PAD_LEFT)) ?></td>
                            <td><?= e($accom['check_out_date'] ? date('d-m-Y', strtotime($accom['check_out_date'])) : '') ?></td>
                            <td><?= e($accom['view_type']) ?></td>
                            <td><?= e($accom['meal_plan']) ?></td>
                            <td><?= e($accom['confirmation_no']) ?></td>
                            <td><?= e($accom['hotel_name']) ?></td>
                        </tr>
                        <tr class="contact-info-row">
                            <td colspan="9">
                                <div class="contact-wrapper">
                                    <span class="city-info">
                                        For Check-Inn <?= e($accom['city']) ?>:
                                    </span>
                                    <span class="contact-details">
                                        (Day Time) <?= e($accom['checkin_day_contact_name']) ?> (<?= e($accom['checkin_day_contact_phone']) ?>) ,
                                        (Night Time) <?= e($accom['checkin_night_contact_name']) ?> (<?= e($accom['checkin_night_contact_phone']) ?>)
                                    </span>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Transport / Services -->
            <h2 class="section-title">Transport / Services</h2>
            <table class="data-table transport-table">
                <thead>
                    <tr>
                        <th>Transporter</th>
                        <th>Type</th>
                        <th>Description</th>
                        <th>BRN</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= e($voucher['transporter_name']) ?></td>
                        <td><?= e($voucher['transport_type']) ?></td>
                        <td><?= e($voucher['transport_description']) ?></td>
                        <td><?= e($voucher['transport_brn']) ?></td>
                    </tr>
                    <tr class="transport-helpline">
                        <td colspan="4">
                            <!-- This span holds the numbers and will be centered -->
                            <span class="helpline-numbers">
                                <?= e($voucher['transport_helpline_1']) ?> | <?= e($voucher['transport_helpline_2']) ?>
                            </span>

                            <!-- This span holds the label and will be the overlay -->
                            <span class="helpline-label">
                                TRANSPORT FROM MAKKAH HELPLINE:
                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>

            <!-- Flights & QR Code -->
            <div class="flights-section">

                <!-- A wrapper to group and center the flight boxes -->
                <div class="flight-boxes-wrapper">

                    <!-- DEPARTURE BOX -->
                    <div class="flight-box">
                        <div class="flight-box-title">Departure (Pakistan To KSA)</div>
                        <div class="flight-grid">
                            <div class="flight-header-row">
                                <div>Flight</div>
                                <div>Sector</div>
                                <div>Departure</div>
                                <div>Arrival</div>
                            </div>
                            <div class="flight-details-row">
                                <div><?= e($departure_flight['flight_no'] ?? 'N/A') ?></div>
                                <div><?= e($departure_flight['sector'] ?? 'N/A') ?></div>
                                <div><?= e($departure_flight ? date('d-M H:i', strtotime($departure_flight['departure_datetime'])) : 'N/A') ?></div>
                                <div><?= e($departure_flight ? date('d-M H:i', strtotime($departure_flight['arrival_datetime'])) : 'N/A') ?></div>
                            </div>
                        </div>
                    </div>

                    <!-- ARRIVAL BOX -->
                    <div class="flight-box">
                        <div class="flight-box-title">Arrival (KSA To Pakistan)</div>
                        <div class="flight-grid">
                            <div class="flight-header-row">
                                <div>Flight</div>
                                <div>Sector</div>
                                <div>Departure</div>
                                <div>Arrival</div>
                            </div>
                            <div class="flight-details-row">
                                <div><?= e($arrival_flight['flight_no'] ?? 'N/A') ?></div>
                                <div><?= e($arrival_flight['sector'] ?? 'N/A') ?></div>
                                <div><?= e($arrival_flight ? date('d-M H:i', strtotime($arrival_flight['departure_datetime'])) : 'N/A') ?></div>
                                <div><?= e($arrival_flight ? date('d-M H:i', strtotime($arrival_flight['arrival_datetime'])) : 'N/A') ?></div>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- The QR code -->
                <div class="qr-code-box">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=http://travelfirst.pk/&bgcolor=ffffff" alt="travelfirst.pk QR Code">
                </div>

            </div>

            <!-- Mutamers -->
            <h2 class="section-title">Mutamers</h2>
            <table class="data-table mutamers-table">
                <thead>
                    <tr>
                        <th>SN</th>
                        <th class="mutamer-name">Mutamer Name</th>
                        <th>Passport No</th>
                        <th>Pax</th>
                        <th>Bed</th>
                        <th>Group #</th>
                        <th>Visa #</th>
                        <th>PNR #</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sn = 1;
                    foreach ($mutamers as $mutamer): ?>
                        <tr>
                            <td><?= str_pad($sn++, 2, '0', STR_PAD_LEFT) ?></td>
                            <td class="mutamer-name"><?= e($mutamer['mutamer_name']) ?></td>
                            <td><?= e($mutamer['passport_no']) ?></td>
                            <td><?= e($mutamer['pax_type']) ?></td>
                            <td><?= e($mutamer['bed_required']) ?></td>
                            <td><?= e($mutamer['group_no']) ?></td>
                            <td><?= e($mutamer['visa_no']) ?></td>
                            <td><?= e($mutamer['pnr_no']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Urdu Notes Section with Pointers (Corrected for RTL) -->
            <div class="urdu-notes-section">
                <?php
                // Get the raw Urdu text and sanitize it
                $urdu_text = e($voucher['notes_urdu']);

                // Split the text into an array of lines
                $lines = explode("\n", str_replace("\r\n", "\n", $urdu_text));

                // Prepare a new array for lines with pointers
                $processed_lines = [];

                // Loop through each line
                foreach ($lines as $line) {
                    $trimmed_line = trim($line);
                    // Add a pointer only if the line has content
                    if ($trimmed_line !== '') {
                        // *** THE FIX IS HERE ***
                        // Place the pointer BEFORE the text in the string.
                        // In an RTL context, this will render it on the far right.
                        $processed_lines[] = '➤&nbsp;' . $trimmed_line;
                    } else {
                        // Preserve empty lines
                        $processed_lines[] = '';
                    }
                }

                // Join the processed lines back together with HTML line breaks
                echo implode('<br>', $processed_lines);
                ?>
            </div>
            <!-- RESTORED: Signature Block -->
            <div class="signature-block">
                <strong>Thanks & Regards</strong><br>
                System Administrator<br>
                <strong>Reservations:</strong><br>
                Print Date: <?= date('M d, Y, h:i A') ?>
            </div>

            <!-- Footer Logo Banner -->
            <div class="airline-logo-banner">
                <img src="https://th.bing.com/th/id/R.938b2794799d1ae3aace562f21021a5a?rik=hrZSyXAAS49ysw&riu=http%3a%2f%2fpluspng.com%2fimg-png%2fsaudia-airlines-logo-png--7349.jpg&ehk=8YKm%2fwQxoSh0PTZSSspliymXkkRgbPcchMDNfbwa%2bos%3d&risl=&pid=ImgRaw&r=0" alt="Saudi Airlines">
                <img src="https://pakobserver.net/wp-content/uploads/2022/08/airsial.jpg" alt="Air Sial">
                <img src="https://tse1.mm.bing.net/th/id/OIP.bdAsEsXsUaOtnEpCDO7TwAHaCh?rs=1&pid=ImgDetMain&o=7&rm=3" alt="PIA">
                <img src="https://static.wixstatic.com/media/9b43b8_d22747ba23d94788a2447f2a3eea18bc~mv2.png/v1/fill/w_980,h_843,al_c,q_90,usm_0.66_1.00_0.01,enc_auto/9b43b8_d22747ba23d94788a2447f2a3eea18bc~mv2.png" alt="Serene Air">
                <img src="https://graficsea.com/wp-content/uploads/2021/12/Air-Blue-.png" alt="Air Blue">
                <img src="https://logodownload.org/wp-content/uploads/2018/02/emirates-logo-1.png" alt="Emirates">
                <img src="https://tse4.mm.bing.net/th/id/OIP.vVJs0u74XeeC9uGR8zopqQHaEK?rs=1&pid=ImgDetMain&o=7&rm=3" alt="Etihad Airways">
                <img src="https://tse3.mm.bing.net/th/id/OIP.58Hq-dovqtIsl9w-TpxftAHaEK?rs=1&pid=ImgDetMain&o=7&rm=3" alt="Oman Air">
                <img src="https://tse4.mm.bing.net/th/id/OIP.aDXn-nMoN5Uz_a7bfaN-WwHaHa?rs=1&pid=ImgDetMain&o=7&rm=3" alt="Flynas">
                <img src="https://tse4.mm.bing.net/th/id/OIP.NWyLNWkEW9M48TJtfuV60gHaHZ?rs=1&pid=ImgDetMain&o=7&rm=3" alt="Salam Air">
                <img src="https://tse2.mm.bing.net/th/id/OIP.5Sajlu2mYXx-D9S4Xc0KTQHaEK?rs=1&pid=ImgDetMain&o=7&rm=3" alt="Jazeera Airways">
            </div>

        </div>
    </div>
</body>

</html>