<?php
session_start();
include_once '../db-config.php';

// Security check
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin' || !isset($_GET['user_id'])) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$user_id = (int)$_GET['user_id'];
$response = [
    'package_invoices' => [],
    'ticket_invoices' => []
];

// Fetch Package Invoices
$stmt_pkg = $conn->prepare("SELECT id, invoice_number, issue_date FROM invoices WHERE user_id = ? ORDER BY issue_date DESC");
$stmt_pkg->bind_param("i", $user_id);
$stmt_pkg->execute();
$response['package_invoices'] = $stmt_pkg->get_result()->fetch_all(MYSQLI_ASSOC);

// Fetch Ticket Invoices
$stmt_tkt = $conn->prepare("SELECT id, invoice_number, issue_date FROM ticket_invoices WHERE user_id = ? ORDER BY issue_date DESC");
$stmt_tkt->bind_param("i", $user_id);
$stmt_tkt->execute();
$response['ticket_invoices'] = $stmt_tkt->get_result()->fetch_all(MYSQLI_ASSOC);

header('Content-Type: application/json');
echo json_encode($response);
?>