<?php
session_start();
include_once '../db-config.php';

// --- SECURITY CHECK ---
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    header("location: ../login.php");
    exit;
}

function e($string) { return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8'); }

// --- HANDLE POST ACTION FOR DELETING INQUIRIES ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] === 'delete_selected_inquiries') {
    if (!empty($_POST['selected_inquiry_ids']) && is_array($_POST['selected_inquiry_ids'])) {
        $ids_to_delete = array_map('intval', $_POST['selected_inquiry_ids']);
        if (!empty($ids_to_delete)) {
            $placeholders = implode(',', array_fill(0, count($ids_to_delete), '?'));
            $types = str_repeat('i', count($ids_to_delete));
            $sql = "DELETE FROM umrah_inquiries WHERE id IN ($placeholders)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param($types, ...$ids_to_delete);
            if ($stmt->execute()) {
                $_SESSION['success_message'] = count($ids_to_delete) . " web inquiry/inquiries deleted successfully.";
            } else {
                $_SESSION['error_message'] = "Error deleting inquiries: " . $stmt->error;
            }
        }
    } else {
        $_SESSION['error_message'] = "No inquiries were selected for deletion.";
    }
    header("Location: dashboard.php");
    exit;
}

// --- HANDLE POST ACTION FOR DELETING FLIGHT BOOKINGS ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] === 'delete_selected_bookings') {
    if (!empty($_POST['selected_booking_ids']) && is_array($_POST['selected_booking_ids'])) {
        $ids_to_delete = array_map('intval', $_POST['selected_booking_ids']);
        if (!empty($ids_to_delete)) {
            $placeholders = implode(',', array_fill(0, count($ids_to_delete), '?'));
            $types = str_repeat('i', count($ids_to_delete));
            $sql = "DELETE FROM bookings WHERE id IN ($placeholders)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param($types, ...$ids_to_delete);
            if ($stmt->execute()) {
                $_SESSION['success_message'] = count($ids_to_delete) . " pending flight booking(s) deleted successfully.";
            } else {
                $_SESSION['error_message'] = "Error deleting bookings: " . $stmt->error;
            }
        }
    } else {
        $_SESSION['error_message'] = "No bookings were selected for deletion.";
    }
    header("Location: dashboard.php");
    exit;
}


// --- 1. FETCH DATA FOR TOP STAT CARDS ---
$totalCustomers = $conn->query("SELECT COUNT(id) as count FROM users WHERE user_type = 'customer'")->fetch_assoc()['count'];
$totalAgents = $conn->query("SELECT COUNT(id) as count FROM users WHERE user_type = 'agent'")->fetch_assoc()['count'];
$totalPackageInvoices = $conn->query("SELECT COUNT(id) as count FROM invoices")->fetch_assoc()['count'];
$totalTicketInvoices = $conn->query("SELECT COUNT(id) as count FROM ticket_invoices")->fetch_assoc()['count'];

// --- 2. CALCULATE FINANCIAL SUMMARY ---
$total_receivables_package = (float)($conn->query("SELECT SUM(grand_total_pkr) FROM invoices")->fetch_row()[0] ?? 0);
$total_receivables_ticket = (float)($conn->query("SELECT SUM(grand_total_pkr) FROM ticket_invoices")->fetch_row()[0] ?? 0);
$total_receivables = $total_receivables_package + $total_receivables_ticket;

$total_costs_package = (float)($conn->query("SELECT SUM(grand_total_pkr_cost) FROM invoices")->fetch_row()[0] ?? 0);
$total_costs_ticket = (float)($conn->query("SELECT SUM(grand_total_pkr_cost) FROM ticket_invoices")->fetch_row()[0] ?? 0);
$total_costs = $total_costs_package + $total_costs_ticket;

$payments_received = (float)($conn->query("SELECT SUM(credit_amount) FROM payments")->fetch_row()[0] ?? 0);
$payments_made = (float)($conn->query("SELECT SUM(debit_amount) FROM payments")->fetch_row()[0] ?? 0);

$net_profit = $total_receivables - $total_costs;
$balance_due = $total_receivables - $payments_received;


// --- 3. FETCH DATA FOR BOTTOM TABLES ---
$pendingBookings = $conn->query("SELECT b.id, b.booking_ref, b.created_at, u.name as user_name FROM bookings b LEFT JOIN users u ON b.user_id = u.id WHERE b.status = 'pending' ORDER BY b.created_at DESC LIMIT 5")->fetch_all(MYSQLI_ASSOC);
$pendingWebInquiries = $conn->query("SELECT id, customer_name, package_name, created_at FROM umrah_inquiries WHERE status = 'Pending' ORDER BY created_at DESC LIMIT 5")->fetch_all(MYSQLI_ASSOC);

// Flash messages
$success_message = $_SESSION['success_message'] ?? null; unset($_SESSION['success_message']);
$error_message = $_SESSION['error_message'] ?? null; unset($_SESSION['error_message']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="icon" type="image/png" href="../images/logo-icon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="admin-style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        .main-content { min-width: 0; }
        .content-body { padding: 1.5rem; }
        .stat-card-link { text-decoration: none; }
        .stat-card {
            background-color: #fff;
            border-radius: .5rem;
            padding: 1.5rem;
            display: flex;
            align-items: center;
            gap: 1.5rem;
            border: 1px solid #dee2e6;
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.1);
        }
        .stat-card .icon {
            font-size: 2rem;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: grid;
            place-items: center;
        }
        .stat-card .value { font-size: 2rem; font-weight: 700; line-height: 1.2; color: #212529; }
        .stat-card .label { font-size: 1rem; color: #6c757d; }
        .table-responsive .checkbox-cell { width: 40px; text-align: center; }
        .bulk-actions-bar {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
<div class="dashboard-wrapper">
    <?php include 'sidebar.php'; ?>
    <div class="main-content">
        <header class="main-header">
            <button class="menu-toggle" id="menu-toggle"><i class="fas fa-bars"></i></button>
            <div class="user-info"><span>Welcome, <strong><?= e($_SESSION['user_name'] ?? 'Admin'); ?></strong></span></div>
        </header>
        <main class="content-body">
            <h1 class="page-title">Dashboard Overview</h1>

            <?php if ($success_message): ?><div class="alert alert-success"><?= e($success_message); ?></div><?php endif; ?>
            <?php if ($error_message): ?><div class="alert alert-danger"><?= e($error_message); ?></div><?php endif; ?>

            <div class="row g-4 mb-4">
                <div class="col-lg-3 col-md-6">
                    <a href="manage-users.php?type=customer" class="stat-card-link">
                        <div class="stat-card"><div class="icon bg-primary-subtle text-primary"><i class="fas fa-users"></i></div><div><div class="value"><?= $totalCustomers ?? 0 ?></div><div class="label">Total Customers</div></div></div>
                    </a>
                </div>
                <div class="col-lg-3 col-md-6">
                    <a href="manage-users.php?type=agent" class="stat-card-link">
                        <div class="stat-card"><div class="icon bg-secondary-subtle text-secondary"><i class="fas fa-user-tie"></i></div><div><div class="value"><?= $totalAgents ?? 0 ?></div><div class="label">Total Agents</div></div></div>
                    </a>
                </div>
                <div class="col-lg-3 col-md-6">
                    <a href="manage-invoices.php" class="stat-card-link">
                        <div class="stat-card"><div class="icon bg-success-subtle text-success"><i class="fas fa-box-open"></i></div><div><div class="value"><?= $totalPackageInvoices ?? 0 ?></div><div class="label">Package Invoices</div></div></div>
                    </a>
                </div>
                <div class="col-lg-3 col-md-6">
                    <a href="ticket-invoices-list.php" class="stat-card-link">
                        <div class="stat-card"><div class="icon bg-warning-subtle text-warning"><i class="fas fa-ticket-alt"></i></div><div><div class="value"><?= $totalTicketInvoices ?? 0 ?></div><div class="label">Ticket Invoices</div></div></div>
                    </a>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header"><h3 class="h5 mb-0">All-Time Financial Summary</h3></div>
                <div class="card-body">
                    <div class="row g-3 text-center">
                        <div class="col-md-4 col-lg-2"><div class="p-2 bg-light rounded"><div class="text-muted small">Receivables</div><div class="fs-5 fw-bold text-primary"><?= number_format($total_receivables) ?></div></div></div>
                        <div class="col-md-4 col-lg-2"><div class="p-2 bg-light rounded"><div class="text-muted small">Payments Received</div><div class="fs-5 fw-bold text-success"><?= number_format($payments_received) ?></div></div></div>
                        <div class="col-md-4 col-lg-2"><div class="p-2 bg-light rounded"><div class="text-muted small">Balance Due</div><div class="fs-5 fw-bold text-info"><?= number_format($balance_due) ?></div></div></div>
                        <div class="col-md-4 col-lg-2"><div class="p-2 bg-light rounded"><div class="text-muted small">Total Costs</div><div class="fs-5 fw-bold text-warning"><?= number_format($total_costs) ?></div></div></div>
                        <div class="col-md-4 col-lg-2"><div class="p-2 bg-light rounded"><div class="text-muted small">Payments Made</div><div class="fs-5 fw-bold text-danger"><?= number_format($payments_made) ?></div></div></div>
                        <div class="col-md-4 col-lg-2"><div class="p-2 bg-light rounded"><div class="text-muted small">Net Profit</div><div class="fs-5 fw-bold" style="color: #6f42c1;"><?= number_format($net_profit) ?></div></div></div>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h3 class="h5 mb-0">Pending Flight Bookings</h3>
                            <a href="manage-flight-requests.php?filter=pending" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <form action="dashboard.php" method="POST" id="booking-delete-form">
                            <input type="hidden" name="action" value="delete_selected_bookings">
                            <div class="card-body p-0">
                                <div class="bulk-actions-bar px-3 pt-3">
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete the selected flight bookings?');">
                                        <i class="fas fa-trash"></i> Delete Selected
                                    </button>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th class="checkbox-cell"><input type="checkbox" id="select-all-bookings"></th>
                                                <th>Reference</th>
                                                <th>Submitted By</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($pendingBookings)): foreach ($pendingBookings as $booking): ?>
                                            <tr>
                                                <td class="checkbox-cell"><input type="checkbox" name="selected_booking_ids[]" class="booking-checkbox" value="<?= e($booking['id']) ?>"></td>
                                                <td><strong><?= e($booking['booking_ref']) ?></strong><br><small><?= date('d M, Y', strtotime($booking['created_at'])) ?></small></td>
                                                <td><?= e($booking['user_name']) ?></td>
                                                <td><a href="process-booking.php?id=<?= $booking['id'] ?>" class="btn btn-sm btn-primary">Process</a></td>
                                            </tr>
                                            <?php endforeach; else: ?>
                                            <tr><td colspan="4" class="text-center p-4">No pending flight bookings.</td></tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                     <div class="card h-100">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h3 class="h5 mb-0">Pending Web Inquiries</h3>
                            <a href="view-inquiries.php?filter=pending" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <form action="dashboard.php" method="POST" id="inquiry-delete-form">
                            <input type="hidden" name="action" value="delete_selected_inquiries">
                            <div class="card-body p-0">
                                <div class="bulk-actions-bar px-3 pt-3">
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete the selected inquiries?');">
                                        <i class="fas fa-trash"></i> Delete Selected
                                    </button>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th class="checkbox-cell"><input type="checkbox" id="select-all-inquiries"></th>
                                                <th>Customer</th>
                                                <th>Package</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($pendingWebInquiries)): foreach ($pendingWebInquiries as $inquiry): ?>
                                            <tr>
                                                <td class="checkbox-cell"><input type="checkbox" name="selected_inquiry_ids[]" class="inquiry-checkbox" value="<?= e($inquiry['id']) ?>"></td>
                                                <td><strong><?= e($inquiry['customer_name']) ?></strong></td>
                                                <td><?= e($inquiry['package_name']) ?></td>
                                                <td><?= date('d M, Y', strtotime($inquiry['created_at'])) ?></td>
                                            </tr>
                                            <?php endforeach; else: ?>
                                            <tr><td colspan="4" class="text-center p-4">No pending web inquiries.</td></tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const menuToggle = document.getElementById('menu-toggle');
        if (menuToggle) {
            menuToggle.addEventListener('click', () => document.querySelector('.dashboard-wrapper').classList.toggle('sidebar-open'));
        }

        // Logic for "Select All" checkbox for inquiries
        const selectAllInquiries = document.getElementById('select-all-inquiries');
        if (selectAllInquiries) {
            selectAllInquiries.addEventListener('change', function() {
                document.querySelectorAll('.inquiry-checkbox').forEach(checkbox => {
                    checkbox.checked = this.checked;
                });
            });
        }
        
        // Logic for "Select All" checkbox for bookings
        const selectAllBookings = document.getElementById('select-all-bookings');
        if (selectAllBookings) {
            selectAllBookings.addEventListener('change', function() {
                document.querySelectorAll('.booking-checkbox').forEach(checkbox => {
                    checkbox.checked = this.checked;
                });
            });
        }
    });
</script>
</body>
</html>