<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include 'db-config.php';

if (!isset($_SESSION['user_id'])) {
    header("location: login.php");
    exit;
}
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'agent') {
    header("location: my-account.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$user_name = '';
$user_email = '';
$company_phone_1 = ''; // CHANGED from mobile_number
$success_message = '';
$error_message = '';

$stmt = $conn->prepare("SELECT name, email, company_phone_1 FROM users WHERE id = ?"); // CHANGED
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
if ($user = $result->fetch_assoc()) {
    $user_name = $user['name'];
    $user_email = $user['email'];
    $company_phone_1 = $user['company_phone_1']; // CHANGED
}
$stmt->close();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['update_profile'])) {
        // This form now only updates the name, the phone numbers are on the other page.
        $new_name = trim($_POST['name']);
        
        $stmt = $conn->prepare("UPDATE users SET name = ? WHERE id = ?");
        $stmt->bind_param("si", $new_name, $user_id);
        if ($stmt->execute()) {
            $_SESSION['user_name'] = $new_name; // Update session
            $user_name = $new_name;
            $success_message = "Profile updated successfully!";
        } else {
            $error_message = "Error updating profile. Please try again.";
        }
        $stmt->close();
    }

    if (isset($_POST['update_password'])) {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];

        if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
            $error_message = "All password fields are required.";
        } elseif ($new_password !== $confirm_password) {
            $error_message = "New password and confirm password do not match.";
        } else {
            $stmt = $conn->prepare("SELECT password FROM users WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $user_data = $result->fetch_assoc();

            if ($user_data && password_verify($current_password, $user_data['password'])) {
                $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $update_stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
                $update_stmt->bind_param("si", $new_hashed_password, $user_id);
                if ($update_stmt->execute()) {
                    $success_message = "Password updated successfully!";
                } else {
                    $error_message = "Error updating password. Please try again.";
                }
                $update_stmt->close();
            } else {
                $error_message = "Incorrect current password.";
            }
            $stmt->close();
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Agent Profile</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <link rel="stylesheet" href="css/account-style.css">
</head>
<body>
    <?php include 'header.php'; ?>
    <main class="account-page-wrapper">
        <div class="account-container">
            <?php include 'agent-sidebar.php'; ?>
            <div class="account-content">
                <div class="content-card">
                    <h2><i class="fa-solid fa-user-pen"></i> Edit Personal Profile</h2>
                    <p class="content-description">Update your personal information below. Your email address cannot be changed.</p>

                    <?php if ($success_message && isset($_POST['update_profile'])): ?><div class="form-message success"><?php echo $success_message; ?></div><?php endif; ?>
                    <?php if ($error_message && isset($_POST['update_profile'])): ?><div class="form-message error"><?php echo $error_message; ?></div><?php endif; ?>

                    <form class="account-form" method="POST" action="">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="name">Full Name</label>
                                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user_name ?? ''); ?>" >
                            </div>
                            <div class="form-group">
                                <label for="company_phone_1">Primary Phone (edit in Company Profile)</label>
                                <input type="tel" id="company_phone_1" name="company_phone_1" value="<?php echo htmlspecialchars($company_phone_1 ?? ''); ?>" disabled>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="email">Email Address (cannot be changed)</label>
                            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user_email ?? ''); ?>" disabled>
                        </div>
                        <div class="form-footer">
                            <button type="submit" name="update_profile" class="btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
                <div class="content-card">
                    <h2><i class="fa-solid fa-lock"></i> Change Password</h2>
                    <p class="content-description">For your security, please enter your current password to make changes.</p>

                    <?php if ($success_message && isset($_POST['update_password'])): ?><div class="form-message success"><?php echo $success_message; ?></div><?php endif; ?>
                    <?php if ($error_message && isset($_POST['update_password'])): ?><div class="form-message error"><?php echo $error_message; ?></div><?php endif; ?>

                    <form class="account-form" method="POST" action="">
                        <div class="form-group">
                            <label for="current_password">Current Password</label>
                            <input type="password" id="current_password" name="current_password" required>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="new_password">New Password</label>
                                <input type="password" id="new_password" name="new_password" required>
                            </div>
                            <div class="form-group">
                                <label for="confirm_password">Confirm New Password</label>
                                <input type="password" id="confirm_password" name="confirm_password" required>
                            </div>
                        </div>
                        <div class="form-footer">
                            <button type="submit" name="update_password" class="btn-primary">Update Password</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
    <?php include 'footer.php'; ?>
</body>
</html>