<?php
// get-package-data.php
header('Content-Type: application/json');
include_once 'db-config.php';

$response = [
    'visa_rates' => [],
    'hotel_rates' => [
        'Makkah' => [],
        'Madinah' => []
    ],
    'transport_rates' => [],
    'ziyarat_rates' => []
];

try {
    // Fetch Visa Rates
    $visa_result = $conn->query("SELECT id, category_name, pax_group, rate_sar FROM custom_package_visa_rates ORDER BY id");
    if ($visa_result) {
        while ($row = $visa_result->fetch_assoc()) {
            $response['visa_rates'][] = $row;
        }
    }

    // Fetch Hotel Rates
    $hotel_result = $conn->query("SELECT id, hotel_name, city, star_rating, distance_info, notes, rate_quad, rate_trpl, rate_dubl, rate_room_basis, currency FROM custom_package_hotel_rates ORDER BY city, hotel_name");
    if ($hotel_result) {
        while ($row = $hotel_result->fetch_assoc()) {
            // Rename keys to match JS expectations for sharing
            $row['rate_sharing_quad'] = $row['rate_quad'];
            $row['rate_sharing_trpl'] = $row['rate_trpl'];
            $row['rate_sharing_dubl'] = $row['rate_dubl'];
            unset($row['rate_quad'], $row['rate_trpl'], $row['rate_dubl']);

            if ($row['city'] === 'Makkah') {
                $response['hotel_rates']['Makkah'][] = $row;
            } elseif ($row['city'] === 'Madinah') {
                $response['hotel_rates']['Madinah'][] = $row;
            }
        }
    }

    // Fetch Transport Rates
    $transport_result = $conn->query("SELECT id, sector_name, vehicle_type, rate_sar FROM custom_package_transport_rates ORDER BY id");
    if ($transport_result) {
        while ($row = $transport_result->fetch_assoc()) {
            $response['transport_rates'][] = $row;
        }
    }

    // Fetch Ziyarat Rates
    $ziyarat_result = $conn->query("SELECT id, city, vehicle_type, rate_sar FROM custom_package_ziyarat_rates ORDER BY id");
    if ($ziyarat_result) {
        while ($row = $ziyarat_result->fetch_assoc()) {
            $response['ziyarat_rates'][] = $row;
        }
    }

    echo json_encode($response);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to fetch package data from the server.']);
}

$conn->close();
?>