<?php
// group-booking-login-check.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$ref_id = $_GET['ref'] ?? '';
$destination_url = 'group-booking-detail.php?ref=' . urlencode($ref_id);

// If the user is not logged in...
if (!isset($_SESSION['user_id'])) {
    // Save the intended destination URL in the session
    $_SESSION['login_redirect'] = $destination_url;
    
    // Set a friendly message for the login page
    $_SESSION['error_message'] = "Please log in or create an account to book this group fare.";
    
    // Redirect to the login page
    header('Location: login.php');
    exit();
}

// If the user is logged in...
// ...simply redirect them straight to the booking detail page.
header('Location: ' . $destination_url);
exit();
?>