<?php
// Start session before any output
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'db-config.php'; // This line creates the $conn variable.
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Group Fares - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="stylesheet" href="css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<style> 
.hero-section {
    background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url('./images/bg.jpg');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    position: relative;
    color: white;
    padding-top: 150px;
    padding-bottom: 100px;
    text-align: center;
}

/* ===== MOBILE RESPONSIVE ===== */
@media (max-width: 768px) {
    .hero-section {
        padding-top: 100px;
        padding-bottom: 80px;
        background-position: top center;
    }
}

@media (max-width: 480px) {
    .hero-section {
        padding-top: 80px;
        padding-bottom: 60px;
        background-image: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url('./images/bg.jpg');
        background-position: center top;
        text-align: center;
    }

    .hero-section h1, 
    .hero-section p {
        font-size: 0.9rem;
        line-height: 1.4;
        padding: 0 1rem;
    }
}

</style>
<body>

    <?php include 'header.php'; ?>

    <main>
        <section class="hero-section">
            <div class="hero-content">
                <h1>Exclusive Group Fares</h1>
                <p>Travel together and save more with our special group flight deals from top airlines.</p>
            </div>

            <div class="search-container">
                <div class="tabs-wrapper">
                    <div class="service-tabs">
                        <a href="index.php" class="tab"><i class="fa-solid fa-plane-up"></i> Ticket</a>
                    <a href="group-fares.php" class="tab active"><i class="fa-solid fa-users"></i> Groups</a>
                    <a href="umrah-packages.php" class="tab"><i class="fa-solid fa-kaaba"></i> Umrah</a>
                    <a href="hotels.php" class="tab"><i class="fa-solid fa-hotel"></i> Hotels</a>
                    <a href="visa-services.php" class="tab"><i class="fa-solid fa-passport"></i> Visas</a>
                    <a href="custom-package.php" class="tab"><i class="fa-solid fa-kaaba"></i> Custom Package</a>
                    </div>
                </div>

                <div class="search-form-wrapper">
                    <div class="umrah-welcome-text">
                        <h2>Exclusive Group Fares at <strong>Unbeatable Prices</strong></h2>
                        <p>Explore our curated list of special group flight deals from leading airlines, available below.</p>
                        <p class="guarantee-line">Exclusive Deals | Limited Availability | Best Price Guarantee!</p>
                    </div>
                </div>
            </div>
        </section>

        <?php include 'all-group-fares.php'; ?>
        <?php include 'floating-icon.php'; ?>
        <?php include 'footer.php'; ?>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Sidebar Logic
            const menuToggle = document.querySelector('.menu-toggle');
            const mobileSidebar = document.querySelector('.mobile-sidebar');
            const sidebarOverlay = document.querySelector('.sidebar-overlay');
            if (menuToggle && mobileSidebar && sidebarOverlay) {
                menuToggle.addEventListener('click', () => {
                    mobileSidebar.classList.add('active');
                    sidebarOverlay.classList.add('active');
                });
                const closeSidebar = () => {
                    mobileSidebar.classList.remove('active');
                    sidebarOverlay.classList.remove('active');
                };
                document.querySelector('.sidebar-close-btn').addEventListener('click', closeSidebar);
                sidebarOverlay.addEventListener('click', closeSidebar);
            }
        });
    </script>
</body>
</html>