<?php
include 'db-config.php';

$all_rates_by_sheet_id = [];
$entries_result = $conn->query("SELECT * FROM rate_entries ORDER BY period_from ASC");
if ($entries_result) {
    while ($entry = $entries_result->fetch_assoc()) {
        $all_rates_by_sheet_id[$entry['rate_sheet_id']][] = $entry;
    }
}

$makkah_sheets = [];
$madinah_sheets = [];
$sheets_result = $conn->query("SELECT * FROM rate_sheets ORDER BY hotel_name ASC");
if ($sheets_result && $sheets_result->num_rows > 0) {
    while ($sheet = $sheets_result->fetch_assoc()) {
        $sheet['entries'] = $all_rates_by_sheet_id[$sheet['id']] ?? [];

        // This is the improved part: it trims spaces and ignores case.
        $city = strtolower(trim($sheet['city']));

        if ($city === 'makkah') {
            $makkah_sheets[] = $sheet;
        } elseif ($city === 'madinah') {
            $madinah_sheets[] = $sheet;
        }
    }
}

function render_stars($count)
{
    return str_repeat('⭐', (int)$count);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hotel Rates - Lyallpur Travel and Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">


    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: #f0f0f0;
            background-repeat: repeat;
        }

        .page-container {
            padding: 20px;
            max-width: 1000px;
            margin: auto;
        }

        .header-banner img,
        .page-footer img {
            width: 100%;
            display: block;
        }

        .header-banner img {
            border-radius: 8px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            margin-bottom: 20px;
        }

        .important-note {
            background-color: #fffbe6;
            border-left: 5px solid #31a7e2;
            padding: 20px;
            margin: 0 auto 30px auto;
            border-radius: 0 8px 8px 0;
            max-width: 95%;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }

        .important-note h4 {
            margin: 0 0 10px 0;
            font-size: 1.1rem;
            color: #5d490c;
            display: flex;
            align-items: center;
        }

        .important-note h4 i {
            margin-right: 10px;
            font-size: 1.3rem;
        }

        .important-note p {
            margin: 0;
            font-size: 0.95rem;
            color: #333;
            line-height: 1.6;
        }

        .city-section {
            margin-top: 40px;
        }

        .city-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1a1a1a;
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #31a7e2;
            padding-bottom: 10px;
            display: inline-block;
        }

        .center-title {
            text-align: center;
        }

        .rate-sheet-container {
            margin-bottom: 40px;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
            border-radius: 5px;
            overflow: hidden;
            position: relative;
        }

        .rate-sheet-title {
            background-color: #31a7e2;
            color: #000;
            font-size: 1.5rem;
            font-weight: 700;
            padding: 12px 20px;
            text-align: center;
        }

        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .table-responsive::-webkit-scrollbar {
            height: 12px;
        }

        .table-responsive::-webkit-scrollbar-track {
            background: #444;
        }

        .table-responsive::-webkit-scrollbar-thumb {
            background-color: #31a7e2;
            border-radius: 10px;
            border: 3px solid #222222;
        }

        .table-responsive::-webkit-scrollbar-thumb:hover {
            background-color: #ffffff;
        }

        .rates-table {
            width: 100%;
            min-width: 1200px;
            border-collapse: collapse;
            color: #fff;
        }

        .rates-table th,
        .rates-table td {
            border: 1px solid #444;
            padding: 10px 12px;
            text-align: center;
            font-size: 0.95rem;
            vertical-align: middle;
            white-space: nowrap;
        }

        .rates-table thead {
            font-size: 1rem;
            font-weight: 600;
            background-color: #000000;
        }

        .rates-table tbody {
            background-color: #222222;
            color: #e9ecef;
        }

        .rates-table .sub-header th {
            background-color: #1a1a1a;
        }

        .btn-copy-sheet {
            position: absolute;
            top: 10px;
            right: 15px;
            background-color: #0056b3;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 0.85rem;
            font-weight: 600;
            transition: all 0.2s ease;
            z-index: 10;
        }

        .btn-copy-sheet:hover {
            background-color: #004494;
        }

        .btn-copy-sheet.copied {
            background-color: #28a745;
        }

        @media (max-width: 768px) {
            .page-container {
                padding: 10px;
            }

            .city-section-title {
                font-size: 1.8rem;
            }

            .rate-sheet-title {
                font-size: 1.2rem;
                padding-right: 70px;
                text-align: left;
            }

            .btn-copy-sheet {
                padding: 4px 8px;
                font-size: 0.75rem;
            }
        }
    </style>
</head>

<body>

    <div class="page-container">

        <div class="header-banner">
            <img src="images/22.jpg" alt=" Lyallpur Travel and Tours Hajj & Umrah Tours">
        </div>

        <div class="important-note">
            <h4><i class="fa-solid fa-circle-info"></i> Important Note</h4>
            <p>
                All rates displayed on this page are subject to change without prior notice and are strictly based on hotel availability.
                Please contact us to confirm the final rates and availability for your desired dates.
            </p>
        </div>

        <?php if (!empty($makkah_sheets)): ?>
            <section class="city-section">
                <div class="center-title">
                    <h2 class="city-section-title">Makkah Hotels</h2>
                </div>
                <?php foreach ($makkah_sheets as $sheet):
                    $clipboard_text = "HOTEL: " . htmlspecialchars($sheet['hotel_name']) . " (" . str_repeat('⭐', $sheet['stars']) . ") - " . htmlspecialchars($sheet['city']) . "\n--------------------------------------\n";
                    if (!empty($sheet['entries'])) {
                        foreach ($sheet['entries'] as $rate) {
                            $clipboard_text .= "Room: " . htmlspecialchars($rate['room_type']) . " | Period: " . date('d-M', strtotime($rate['period_from'])) . " to " . date('d-M', strtotime($rate['period_till'])) . " | Weekday: " . number_format($rate['rate_weekday']) . " | Weekend: " . number_format($rate['rate_weekend']) . "\n";
                        }
                    }
                ?>
                    <div class="rate-sheet-container">
                        <button class="btn-copy-sheet" data-clipboard-text="<?= htmlspecialchars($clipboard_text) ?>"><i class="fa-solid fa-clipboard"></i> Copy</button>
                        <div class="rate-sheet-title"><?= htmlspecialchars($sheet['hotel_name']) ?> <?= render_stars($sheet['stars']) ?></div>
                        <div class="table-responsive">
                            <table class="rates-table">
                                <thead>
                                    <tr class="main-header">
                                        <th colspan="2">Period</th>
                                        <th rowspan="2">Room Type</th>
                                        <th colspan="2">Rate</th>
                                        <th rowspan="2">4 Nights</th>
                                        <th colspan="2">Supplements</th>
                                        <th colspan="2">Meal Rates</th>
                                    </tr>
                                    <tr class="sub-header">
                                        <th>From</th>
                                        <th>Till</th>
                                        <th>W.D</th>
                                        <th>W.E</th>
                                        <th>Ex Bed</th>
                                        <th>Meal Plan</th>
                                        <th>Lunch</th>
                                        <th>Dinner</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($sheet['entries'])): ?>
                                        <?php foreach ($sheet['entries'] as $rate): ?>
                                            <tr>
                                                <td><?= date('d-M-Y', strtotime($rate['period_from'])) ?></td>
                                                <td><?= date('d-M-Y', strtotime($rate['period_till'])) ?></td>
                                                <td><?= htmlspecialchars($rate['room_type']) ?></td>
                                                <td><?= number_format($rate['rate_weekday']) ?></td>
                                                <td><?= number_format($rate['rate_weekend']) ?></td>
                                                <td><?= $rate['rate_4_nights'] ? number_format($rate['rate_4_nights']) : 'N/A' ?></td>
                                                <td><?= $rate['supplement_ex_bed'] ? number_format($rate['supplement_ex_bed']) : 'N/A' ?></td>
                                                <td><?= htmlspecialchars($rate['supplement_meal_plan'] ?? 'N/A') ?></td>
                                                <td><?= $rate['meal_rate_lunch'] ? number_format($rate['meal_rate_lunch']) : 'N/A' ?></td>
                                                <td><?= $rate['meal_rate_dinner'] ? number_format($rate['meal_rate_dinner']) : 'N/A' ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="10" style="text-align: center; padding: 20px;">No rates are currently available for this hotel. Please contact us for details.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endforeach; ?>
            </section>
        <?php endif; ?>

        <?php if (!empty($madinah_sheets)): ?>
            <section class="city-section">
                <div class="center-title">
                    <h2 class="city-section-title">Madinah Hotels</h2>
                </div>
                <?php foreach ($madinah_sheets as $sheet):
                    $clipboard_text = "HOTEL: " . htmlspecialchars($sheet['hotel_name']) . " (" . str_repeat('⭐', $sheet['stars']) . ") - " . htmlspecialchars($sheet['city']) . "\n--------------------------------------\n";
                    if (!empty($sheet['entries'])) {
                        foreach ($sheet['entries'] as $rate) {
                            $clipboard_text .= "Room: " . htmlspecialchars($rate['room_type']) . " | Period: " . date('d-M', strtotime($rate['period_from'])) . " to " . date('d-M', strtotime($rate['period_till'])) . " | Weekday: " . number_format($rate['rate_weekday']) . " | Weekend: " . number_format($rate['rate_weekend']) . "\n";
                        }
                    }
                ?>
                    <div class="rate-sheet-container">
                        <button class="btn-copy-sheet" data-clipboard-text="<?= htmlspecialchars($clipboard_text) ?>"><i class="fa-solid fa-clipboard"></i> Copy</button>
                        <div class="rate-sheet-title"><?= htmlspecialchars($sheet['hotel_name']) ?> <?= render_stars($sheet['stars']) ?></div>
                        <div class="table-responsive">
                            <table class="rates-table">
                                <thead>
                                    <tr class="main-header">
                                        <th colspan="2">Period</th>
                                        <th rowspan="2">Room Type</th>
                                        <th colspan="2">Rate</th>
                                        <th rowspan="2">4 Nights</th>
                                        <th colspan="2">Supplements</th>
                                        <th colspan="2">Meal Rates</th>
                                    </tr>
                                    <tr class="sub-header">
                                        <th>From</th>
                                        <th>Till</th>
                                        <th>W.D</th>
                                        <th>W.E</th>
                                        <th>Ex Bed</th>
                                        <th>Meal Plan</th>
                                        <th>Lunch</th>
                                        <th>Dinner</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($sheet['entries'])): ?>
                                        <?php foreach ($sheet['entries'] as $rate): ?>
                                            <tr>
                                                <td><?= date('d-M-Y', strtotime($rate['period_from'])) ?></td>
                                                <td><?= date('d-M-Y', strtotime($rate['period_till'])) ?></td>
                                                <td><?= htmlspecialchars($rate['room_type']) ?></td>
                                                <td><?= number_format($rate['rate_weekday']) ?></td>
                                                <td><?= number_format($rate['rate_weekend']) ?></td>
                                                <td><?= $rate['rate_4_nights'] ? number_format($rate['rate_4_nights']) : 'N/A' ?></td>
                                                <td><?= $rate['supplement_ex_bed'] ? number_format($rate['supplement_ex_bed']) : 'N/A' ?></td>
                                                <td><?= htmlspecialchars($rate['supplement_meal_plan'] ?? 'N/A') ?></td>
                                                <td><?= $rate['meal_rate_lunch'] ? number_format($rate['meal_rate_lunch']) : 'N/A' ?></td>
                                                <td><?= $rate['meal_rate_dinner'] ? number_format($rate['meal_rate_dinner']) : 'N/A' ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="10" style="text-align: center; padding: 20px;">No rates are currently available for this hotel. Please contact us for details.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endforeach; ?>
            </section>
        <?php endif; ?>


    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.btn-copy-sheet').forEach(button => {
                button.addEventListener('click', function() {
                    const textToCopy = this.getAttribute('data-clipboard-text');
                    navigator.clipboard.writeText(textToCopy).then(() => {
                        const originalHTML = this.innerHTML;
                        this.innerHTML = '<i class="fa-solid fa-check"></i> Copied!';
                        this.classList.add('copied');
                        setTimeout(() => {
                            this.innerHTML = originalHTML;
                            this.classList.remove('copied');
                        }, 2000);
                    }).catch(err => console.error('Failed to copy hotel rates: ', err));
                });
            });
        });
    </script>
</body>

</html>