<?php
// logout.php

// 1. Always start the session to be able to access and destroy it.
session_start();

// 2. Unset all of the session variables.
// Overwriting with an empty array is a reliable way to clear all data.
$_SESSION = array();

// 3. Destroy the session itself.
// This removes the session data from the server.
session_destroy();

// 4. Redirect the user to the homepage (or any other page).
// The user is now logged out.
header("location: index.php");

// 5. Ensure no other code runs after the redirect.
exit;
?>