<?php
// submit-custom-package.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'db-config.php';
header('Content-Type: application/json');

// --- Receive and Decode Data from JavaScript ---
$data = json_decode(file_get_contents('php://input'), true);

// --- Validation ---
if (!$data || !isset($data['booking_ref']) || !isset($data['summary'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['success' => false, 'message' => 'Invalid or incomplete data received.']);
    exit();
}

try {
    $user_id = $_SESSION['user_id'] ?? null;
    $customer_name = $_SESSION['user_name'] ?? 'Guest User';
    $booking_ref = $data['booking_ref'];
    
    // Encode the entire detailed package structure into JSON for storage
    $package_details_json = json_encode($data, JSON_PRETTY_PRINT);
    if ($package_details_json === false) {
        throw new Exception("Failed to encode package details into JSON.");
    }

    // --- Prepare and Execute Database Insertion ---
    $stmt = $conn->prepare(
        "INSERT INTO custom_package_inquiries (user_id, customer_name, booking_ref, package_details_json, status) 
         VALUES (?, ?, ?, ?, 'Pending')"
    );
    
    if ($stmt === false) {
        throw new Exception("Database prepare statement failed: " . $conn->error);
    }
    
    $stmt->bind_param("isss", $user_id, $customer_name, $booking_ref, $package_details_json);
    
    if (!$stmt->execute()) {
        throw new Exception("Database execution failed: " . $stmt->error);
    }

    $stmt->close();
    $conn->close();

    // --- Prepare for Success Redirect ---
    $_SESSION['submission_success'] = true;
    $_SESSION['success_context_name'] = $customer_name;
    // You can add a new context if you want a different message on the thank you page
    // $_SESSION['success_context_type'] = 'custom_package'; 

    echo json_encode([
        'success' => true,
        'message' => 'Your custom package request has been submitted.',
        'redirect_url' => 'thank-you.php'
    ]);

} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    error_log("Error in submit-custom-package.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'A server error occurred. Please try again later.']);
}
?>