<?php
// We need to start the session to show the correct header state (logged in/out)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Terms and Conditions - RF Travel & Tours</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Main Stylesheet (for variables) -->
    <link rel="stylesheet" href="css/style.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <!-- Re-using the same stylesheet as the privacy policy page -->
    <link rel="stylesheet" href="css/policy-style.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- ========== HERO SECTION ========== -->
    <section class="policy-hero-section">
        <div class="hero-content">
            <h1>Terms & Conditions</h1>
            <p>Please read these terms carefully before using our services.</p>
        </div>
    </section>

    <main class="policy-page-wrapper">
        <div class="container">
            <div class="policy-content-card">
                <p class="last-updated">Last Updated: July 18, 2024</p>

                <h2>1. Agreement to Terms</h2>
                <p>By accessing or using the RF Travel & Tours website (the "Service"), you agree to be bound by these Terms and Conditions. If you disagree with any part of the terms, then you may not access the Service.</p>

                <h2>2. Booking Process</h2>
                <p>All flight bookings made through our website are considered booking requests. A booking is not confirmed until you have been contacted by one of our travel agents, the flight details have been verified, and payment has been successfully processed. We reserve the right to decline any booking request at our discretion.</p>

                <h2>3. User Accounts</h2>
                <p>When you create an account with us, you must provide information that is accurate, complete, and current at all times. You are responsible for safeguarding the password that you use to access the Service and for any activities or actions under your password.</p>
                <ul>
                    <li><strong>Customer Accounts:</strong> Intended for personal use to manage your own travel bookings.</li>
                    <li><strong>Agent Accounts:</strong> Intended for registered travel professionals to manage bookings on behalf of their clients.</li>
                </ul>

                <h2>4. Pricing and Payments</h2>
                <p>Prices for flights are subject to change without notice until a booking is confirmed and ticketed. All prices are quoted in the specified currency (e.g., PKR). Payment procedures will be communicated to you by our agent upon confirmation of your booking request.</p>

                <h2>5. Cancellations, Changes, and Refunds</h2>
                <p>All airline tickets are subject to the rules and regulations of the respective airline. Cancellation fees, change fees, and refund policies are determined solely by the airline. RF Travel & Tours will facilitate these requests on your behalf but is bound by the terms set by the airline. Any agency service fees applied are non-refundable.</p>

                <h2>6. User Responsibilities</h2>
                <p>It is your responsibility to ensure that all passenger information (including names, dates of birth, and passport details) is accurate and matches the travel documents exactly. Any errors may result in the inability to travel or additional fees. You are also responsible for ensuring you have the necessary visas, travel documents, and health requirements for your destination.</p>

                <h2>7. Limitation of Liability</h2>
                <p>RF Travel & Tours acts as an agent for third-party suppliers, such as airlines. We are not liable for any acts, errors, omissions, injuries, losses, accidents, delays, or any other irregularities which may be occasioned by neglect or default of any company or person engaged in conveying the passenger or carrying out the arrangements of the tour.</p>

                <h2>8. Changes to Terms</h2>
                <p>We reserve the right, at our sole discretion, to modify or replace these Terms at any time. We will notify users of any changes by updating the "Last Updated" date of these Terms. It is your responsibility to review these Terms periodically for changes.</p>

                <h2>9. Contact Us</h2>
                <p>If you have any questions about these Terms and Conditions, please get in touch with us by visiting our official <a href="contact-us.php">Contact Us</a> page.</p>
            </div>
        </div>
    </main>

    <?php include 'floating-icon.php'; ?>
    <?php include 'footer.php'; ?>

</body>

</html>