<?php
// Start session before any output
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'db-config.php'; // This line creates the $conn variable.


$umrah_packages_grid_result = null; // Use a new variable name to avoid conflicts
try {
    // Fetches the 3 most recently updated "active" packages.
    $sql = "SELECT * FROM umrah_packages WHERE is_active = 1 ORDER BY last_updated DESC LIMIT 3";
    $umrah_packages_grid_result = $conn->query($sql);
} catch (Exception $e) {
    // In case of a database error, the section will gracefully show the 'no packages' message.
    error_log("Failed to fetch Umrah packages for homepage grid: " . $e->getMessage());
}


?>

<!DOCTYPE html>

<html lang="en">

<head>
    <link rel="icon" type="image/png" href="#">



    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RF Travel & Tours - Your Trusted Company for Umrah Services</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">


    <!-- Link to our CSS file -->
    <link rel="stylesheet" href="css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Flatpickr CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>

<body>


    <?php include 'header.php'; ?>


    <main>
        <section class="hero-section">
            <div class="hero-content">
                <h1>Discover the World <br> and Its Wonders</h1>
                <p>Embark on journeys that inspire the soul and create unforgettable memories beyond imagination.</p>
            </div>

            <div class="search-container">
                <div class="tabs-wrapper">
                    <div class="service-tabs">
                        <a href="index.php" class="tab active"><i class="fa-solid fa-plane-up"></i> Flight</a>
                        <a href="group-fares.php" class="tab"><i class="fa-solid fa-users"></i> Groups</a>
                        <a href="umrah-packages.php" class="tab"><i class="fa-solid fa-kaaba"></i> Umrah</a>
                        <a href="hotels.php" class="tab"><i class="fa-solid fa-hotel"></i> Hotels</a>
                        <a href="holiday-packages.php" class="tab"><i class="fa-solid fa-umbrella-beach"></i> Holidays</a>
                        <a href="visa-services.php" class="tab"><i class="fa-solid fa-passport"></i> Visas</a>
                    </div>
                </div>

                <!-- ============================================= -->
                <!-- ===== INTERACTIVE SEARCH FORM (UPDATED) ===== -->
                <!-- ============================================= -->
                <div class="search-form-wrapper">
                    <!-- Trip Type -->
                    <div class="trip-type">
                        <input type="radio" id="one-way" name="trip-type" value="one-way" checked>
                        <label for="one-way" class="trip-label">One Way</label>

                        <input type="radio" id="return" name="trip-type" value="return">
                        <label for="return" class="trip-label">Return</label>

                        <input type="radio" id="multi-city" name="trip-type" value="multi-city">
                        <label for="multi-city" class="trip-label">Multi-City</label>
                    </div>

                    <form class="flight-search-form" id="flight-search-form">
                        <div class="form-grid trip-form">
                            <!-- From Field -->
                            <div class="form-field from-field dropdown-toggle">
                                <label>FROM</label>
                                <div class="value-main" data-value-code="KHI">Karachi</div>
                                <div class="value-sub">Pakistan- Jinnah International</div>
                                <div class="dropdown-menu location-dropdown">
                                    <div class="dropdown-header"><input type="text" placeholder="Search for a city or airport"></div>
                                    <ul>
                                        <li>Type to search...</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="swap-icon-container">
                                <div class="swap-icon"><i class="fa-solid fa-right-left"></i></div>
                            </div>

                            <!-- To Field -->
                            <div class="form-field to-field dropdown-toggle">
                                <label>TO</label>
                                <div class="value-main" data-value-code="ISB">Islamabad</div>
                                <div class="value-sub">Pakistan- Islamabad International</div>
                                <div class="dropdown-menu location-dropdown">
                                    <div class="dropdown-header"><input type="text" placeholder="Search for a city or airport"></div>
                                    <ul>
                                        <li>Type to search...</li>
                                    </ul>
                                </div>
                            </div>

                            <!-- Journey Date Field -->
                            <div class="form-field date-field" id="journey-date-field">
                                <label>JOURNEY DATE</label>
                                <input type="hidden" class="journey-date-input" id="journey-date-input">
                                <div class="value-main">Select A Date</div>
                            </div>

                            <!-- Return Date Field -->
                            <div class="form-field date-field" id="return-date-field">
                                <label>RETURN DATE</label>
                                <input type="hidden" class="return-date-input" id="return-date-input">
                                <div class="value-main placeholder">Tap to add a return date</div>
                            </div>

                            <!-- Traveler Field -->
                            <div class="form-field traveler-field dropdown-toggle">
                                <label>TRAVELER & CLASS</label>
                                <div class="value-main">1 Traveller</div>
                                <div class="value-sub">Economy</div>
                                <div class="dropdown-menu traveler-dropdown">
                                    <div class="passenger-row">
                                        <span>Adults <small>(12+ years)</small></span>
                                        <div class="passenger-counter">
                                            <button type="button" class="counter-btn" data-type="adults" data-action="decrement">-</button>
                                            <span class="pax-count-adults">1</span>
                                            <button type="button" class="counter-btn" data-type="adults" data-action="increment">+</button>
                                        </div>
                                    </div>
                                    <div class="passenger-row">
                                        <span>Children <small>(2-11 years)</small></span>
                                        <div class="passenger-counter">
                                            <button type="button" class="counter-btn" data-type="children" data-action="decrement">-</button>
                                            <span class="pax-count-children">0</span>
                                            <button type="button" class="counter-btn" data-type="children" data-action="increment">+</button>
                                        </div>
                                    </div>
                                    <div class="passenger-row">
                                        <span>Infants <small>(under 2 years)</small></span>
                                        <div class="passenger-counter">
                                            <button type="button" class="counter-btn" data-type="infants" data-action="decrement">-</button>
                                            <span class="pax-count-infants">0</span>
                                            <button type="button" class="counter-btn" data-type="infants" data-action="increment">+</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="class-selection">
                                        <label><input type="radio" name="flight-class" value="Economy" checked> Economy</label>
                                        <label><input type="radio" name="flight-class" value="Premium Economy"> Premium Economy</label>
                                        <label><input type="radio" name="flight-class" value="Business"> Business</label>
                                    </div>
                                    <div class="dropdown-footer">
                                        <button type="button" class="btn-done">Done</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Container for multi-city extra trips -->
                        <div id="multiCityContainer"></div>

                        <!-- Add Trip Button (only visible in Multi-City) -->
                        <button type="button" id="addTripBtn"
                            style="display:none;margin-top:15px;padding:10px 20px;background:#31a7e2;color:#fff;border:none;border-radius:25px;font-size:14px;font-weight:600;cursor:pointer;box-shadow:0 3px 6px rgba(0,0,0,0.15);transition:0.3s ease;">
                            + Add Another Trip
                        </button>

                        <div class="submit-button-container">
                            <button type="submit" class="btn-show-fare">Show Fare</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>

        <!-- Extra CSS -->
        <style>
            .trip-type {
                display: flex;
                gap: 15px;
                margin-bottom: 15px;
            }

            .trip-type input[type="radio"] {
                display: none;
            }

            .trip-type .trip-label {
                padding: 6px 15px;
                border: 1px solid #ccc;
                border-radius: 20px;
                cursor: pointer;
                font-size: 14px;
                background: #f9f9f9;
                transition: all 0.3s ease;
            }

            .trip-type input[type="radio"]:checked+.trip-label {
                background: #31a7e2;
                color: #fff;
                border-color: #31a7e2;
            }

            #return-date-field {
                display: none;
            }

            #multiCityContainer .trip-form {
                position: relative;
                margin-top: 15px;
                border-top: 1px dashed #ccc;
                padding-top: 15px;
                padding-right: 120px;
                /* Space for remove button */
            }

            .remove-trip-btn {
                position: absolute;
                right: 0;
                top: 50%;
                transform: translateY(-50%);
                padding: 8px 18px;
                background: #e63946;
                color: #fff;
                border: none;
                border-radius: 20px;
                font-size: 13px;
                cursor: pointer;
                font-weight: 500;
            }
        </style>

        <!-- Trip Type + Multi-City Script -->
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const tripOptions = document.querySelectorAll("input[name='trip-type']");
                const returnDateField = document.getElementById("return-date-field");
                const addTripBtn = document.getElementById("addTripBtn");
                const multiCityContainer = document.getElementById("multiCityContainer");
                const mainFormGrid = document.querySelector(".form-grid.trip-form");

                let tripCount = 0;

                function updateFormLayout(tripType) {
                    if (tripType === "one-way") {
                        returnDateField.style.display = "none";
                        addTripBtn.style.display = "none";
                        multiCityContainer.innerHTML = "";
                    } else if (tripType === "return") {
                        returnDateField.style.display = "block";
                        addTripBtn.style.display = "none";
                        multiCityContainer.innerHTML = "";
                    } else if (tripType === "multi-city") {
                        returnDateField.style.display = "none";
                        addTripBtn.style.display = "inline-block";
                        if (multiCityContainer.children.length === 0) {
                            addTripBtn.click();
                        }
                    }
                }

                tripOptions.forEach(option => option.addEventListener("change", (e) => updateFormLayout(e.target.value)));
                updateFormLayout('one-way');

                addTripBtn.addEventListener("click", function() {
                    tripCount++;
                    let newForm = mainFormGrid.cloneNode(true);
                    newForm.querySelector('#return-date-field')?.remove();

                    // === RE-INITIALIZE ALL DYNAMIC ELEMENTS FOR THE CLONED FORM ===

                    // 1. DATE PICKER
                    const newJourneyField = newForm.querySelector('#journey-date-field');
                    newJourneyField.id = `journey-date-field-${tripCount}`;
                    const newJourneyInput = newForm.querySelector('.journey-date-input');
                    newJourneyInput.id = `journey-date-input-${tripCount}`;
                    newJourneyField.querySelector('.value-main').textContent = "Select A Date";
                    newJourneyInput.value = "";

                    const newPicker = flatpickr(newJourneyInput, {
                        minDate: "today",
                        clickOpens: false,
                        positionElement: newJourneyField,
                        onChange: function(selectedDates, dateStr, instance) {
                            if (!selectedDates.length) return;
                            const d = selectedDates[0];
                            instance.element.closest('.date-field').querySelector('.value-main').textContent = `${d.getDate()} ${d.toLocaleString('default', { month: 'short' })} ${d.getFullYear()}`;
                        }
                    });
                    newJourneyField.addEventListener('click', (e) => {
                        e.stopPropagation();
                        newPicker.open();
                    });

                    // 2. LOCATION DROPDOWNS & SEARCH
                    newForm.querySelectorAll('.dropdown-toggle').forEach(toggle => {
                        toggle.addEventListener('click', (e) => {
                            const isActive = toggle.classList.contains('active');
                            document.querySelectorAll('.form-field.active').forEach(f => f.classList.remove('active'));
                            if (!isActive) toggle.classList.add('active');
                            e.stopPropagation();
                        });
                    });
                    newForm.querySelectorAll('.dropdown-menu').forEach(menu => menu.addEventListener('click', e => e.stopPropagation()));
                    newForm.querySelectorAll('.location-dropdown input').forEach(input => {
                        const resultsList = input.closest('.dropdown-menu').querySelector('ul');
                        input.addEventListener('input', () => handleLocationSearch(input, resultsList));
                    });
                    newForm.querySelectorAll('.location-dropdown ul').forEach(list => {
                        list.addEventListener('click', (e) => {
                            const li = e.target.closest('li');
                            if (li && li.dataset.code) {
                                const formField = li.closest('.form-field');
                                formField.querySelector('.value-main').textContent = li.dataset.city;
                                formField.querySelector('.value-main').dataset.valueCode = li.dataset.code;
                                formField.querySelector('.value-sub').textContent = `${li.dataset.country} - ${li.dataset.name}`;
                                formField.classList.remove('active');
                            }
                        });
                    });

                    // 3. SWAP BUTTON
                    newForm.querySelector(".swap-icon").addEventListener("click", function(e) {
                        e.stopPropagation();
                        const fromField = newForm.querySelector(".from-field"),
                            toField = newForm.querySelector(".to-field");
                        const fromVal = {
                            main: fromField.querySelector('.value-main').innerHTML,
                            sub: fromField.querySelector('.value-sub').innerHTML,
                            code: fromField.querySelector('.value-main').dataset.valueCode
                        };
                        const toVal = {
                            main: toField.querySelector('.value-main').innerHTML,
                            sub: toField.querySelector('.value-sub').innerHTML,
                            code: toField.querySelector('.value-main').dataset.valueCode
                        };
                        fromField.querySelector('.value-main').innerHTML = toVal.main;
                        fromField.querySelector('.value-sub').innerHTML = toVal.sub;
                        fromField.querySelector('.value-main').dataset.valueCode = toVal.code;
                        toField.querySelector('.value-main').innerHTML = fromVal.main;
                        toField.querySelector('.value-sub').innerHTML = fromVal.sub;
                        toField.querySelector('.value-main').dataset.valueCode = fromVal.code;
                    });

                    // 4. PASSENGER & CLASS SELECTION
                    const newTravelerField = newForm.querySelector('.traveler-field');
                    newTravelerField.querySelectorAll('input[name="flight-class"]').forEach(radio => {
                        radio.name = `flight-class-${tripCount}`;
                    });
                    newTravelerField.querySelectorAll('.counter-btn').forEach(btn => {
                        btn.addEventListener('click', function() {
                            const countSpan = this.parentElement.querySelector('span');
                            let count = parseInt(countSpan.textContent);
                            if (this.dataset.action === 'increment') count++;
                            else if (count > (this.dataset.type === 'adults' ? 1 : 0)) count--;
                            countSpan.textContent = count;
                            updateTravelerDisplay(newTravelerField);
                        });
                    });
                    newTravelerField.querySelectorAll('input[name^="flight-class-"]').forEach(radio => radio.addEventListener('change', () => updateTravelerDisplay(newTravelerField)));
                    newTravelerField.querySelector('.btn-done').addEventListener('click', () => newTravelerField.classList.remove('active'));

                    // 5. REMOVE TRIP BUTTON
                    const removeBtn = document.createElement("button");
                    removeBtn.type = "button";
                    removeBtn.innerText = "Remove Trip";
                    removeBtn.className = "remove-trip-btn";
                    removeBtn.addEventListener("click", () => newForm.remove());
                    newForm.appendChild(removeBtn);

                    multiCityContainer.appendChild(newForm);
                });
            });
        </script>

        <br><br><br><br><br><br>
        <?php include 'umrah-package-listings.php'; ?>
        <?php include 'international-tours-listings.php'; ?>
        <?php include 'domestic-tours-listings.php'; ?>
        <?php include 'visa-services-listings.php'; ?>
        <?php include 'hotel-listings-section.php'; ?>
        <?php include 'airline-logos.php'; ?>
        <?php include 'promo-cards.php'; ?>
        <?php include 'other_websites.php'; ?>
        <?php include 'floating-icon.php'; ?>
        <?php include 'footer.php'; ?>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    <!-- FINAL SCRIPT with ALL functionality preserved and NEW submission logic -->
    <script>
        let handleLocationSearch;
        // This helper function can now update any traveler display, new or old
        function updateTravelerDisplay(travelerFieldElement) {
            const dropdown = travelerFieldElement.querySelector('.traveler-dropdown');
            const adults = parseInt(dropdown.querySelector('.pax-count-adults').textContent);
            const children = parseInt(dropdown.querySelector('.pax-count-children').textContent);
            const infants = parseInt(dropdown.querySelector('.pax-count-infants').textContent);
            const totalTravelers = adults + children + infants;
            const selectedClass = dropdown.querySelector('input[name^="flight-class"]:checked').value;
            travelerFieldElement.querySelector('.value-main').textContent = `${totalTravelers} Traveller${totalTravelers > 1 ? 's' : ''}`;
            travelerFieldElement.querySelector('.value-sub').textContent = selectedClass;
        }

        document.addEventListener('DOMContentLoaded', function() {
            // --- AMADEUS API LOGIC FOR LOCATION SEARCH ---
            const AMADEUS_API_KEY = 'ODHfAdal8JCJrcFC8NGrbSnAVmCS3hMC';
            const AMADEUS_API_SECRET = '2VHNu0uaCSiGDsT4';
            let amadeusAccessToken = null;
            async function getAmadeusToken() {
                if (amadeusAccessToken) return amadeusAccessToken;
                try {
                    const response = await fetch('https://api.amadeus.com/v1/security/oauth2/token', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: `grant_type=client_credentials&client_id=${AMADEUS_API_KEY}&client_secret=${AMADEUS_API_SECRET}`
                    });
                    if (!response.ok) throw new Error('Token fetch failed');
                    const data = await response.json();
                    amadeusAccessToken = data.access_token;
                    return amadeusAccessToken;
                } catch (error) {
                    console.error("Amadeus Auth Error:", error);
                    return null;
                }
            }
            async function searchLocations(keyword) {
                const token = await getAmadeusToken();
                if (!token) return [];
                const url = `https://api.amadeus.com/v1/reference-data/locations?subType=CITY,AIRPORT&keyword=${keyword}&view=LIGHT`;
                try {
                    const response = await fetch(url, {
                        headers: {
                            'Authorization': `Bearer ${token}`
                        }
                    });
                    if (!response.ok) throw new Error('Location fetch failed');
                    const data = await response.json();
                    return data.data;
                } catch (error) {
                    console.error("Amadeus Search Error:", error);
                    return [];
                }
            }

            function debounce(func, delay) {
                let timeout;
                return function(...args) {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(this, args), delay);
                };
            }
            handleLocationSearch = debounce(async (inputElement, resultsList) => {
                const keyword = inputElement.value;
                if (keyword.length < 2) {
                    resultsList.innerHTML = '<li>Type to search...</li>';
                    return;
                }
                resultsList.innerHTML = '<li class="loading-item">Loading...</li>';
                const locations = await searchLocations(keyword);
                resultsList.innerHTML = '';
                if (locations && locations.length > 0) {
                    locations.forEach(location => {
                        const li = document.createElement('li');
                        li.dataset.code = location.iataCode;
                        li.dataset.city = location.address.cityName;
                        li.dataset.country = location.address.countryName;
                        li.dataset.name = location.name;
                        li.innerHTML = `<strong>${location.address.cityName}</strong>, ${location.address.countryName} <span class="iata-code">${location.iataCode}</span>`;
                        resultsList.appendChild(li);
                    });
                } else {
                    resultsList.innerHTML = '<li class="no-results-item">No results found</li>';
                }
            }, 350);

            // --- INITIAL FORM INTERACTIVITY LOGIC (FOR THE FIRST, NON-CLONED FORM) ---
            document.querySelectorAll('.dropdown-toggle').forEach(toggle => {
                toggle.addEventListener('click', (event) => {
                    if (document.querySelector('.flatpickr-calendar.open')) return;
                    const isActive = toggle.classList.contains('active');
                    document.querySelectorAll('.form-field.active').forEach(openField => openField.classList.remove('active'));
                    if (!isActive) toggle.classList.add('active');
                    event.stopPropagation();
                });
            });
            document.addEventListener('click', () => {
                document.querySelectorAll('.form-field.active').forEach(f => f.classList.remove('active'));
            });
            document.querySelectorAll('.dropdown-menu').forEach(menu => menu.addEventListener('click', (event) => event.stopPropagation()));
            document.querySelectorAll('.location-dropdown input').forEach(input => {
                const resultsList = input.closest('.dropdown-menu').querySelector('ul');
                input.addEventListener('input', () => handleLocationSearch(input, resultsList));
            });
            document.querySelectorAll('.location-dropdown ul').forEach(list => {
                list.addEventListener('click', (event) => {
                    const li = event.target.closest('li');
                    if (li && li.dataset.code) {
                        const formField = li.closest('.form-field');
                        formField.querySelector('.value-main').textContent = li.dataset.city;
                        formField.querySelector('.value-main').dataset.valueCode = li.dataset.code;
                        formField.querySelector('.value-sub').textContent = `${li.dataset.country} - ${li.dataset.name}`;
                        formField.classList.remove('active');
                    }
                });
            });
            document.querySelectorAll('.btn-done').forEach(btn => btn.addEventListener('click', () => btn.closest('.form-field').classList.remove('active')));

            // Use the generic update function for the main traveler field
            const mainTravelerField = document.querySelector('.traveler-field');
            mainTravelerField.querySelectorAll('.counter-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const countSpan = this.parentElement.querySelector('span');
                    let count = parseInt(countSpan.textContent);
                    if (this.dataset.action === 'increment') count++;
                    else if (count > (this.dataset.type === 'adults' ? 1 : 0)) count--;
                    countSpan.textContent = count;
                    updateTravelerDisplay(mainTravelerField);
                });
            });
            mainTravelerField.querySelectorAll('input[name="flight-class"]').forEach(radio => radio.addEventListener('change', () => updateTravelerDisplay(mainTravelerField)));

            document.querySelector('.swap-icon').addEventListener('click', (event) => {
                event.stopPropagation();
                const fromField = document.querySelector('.from-field'),
                    toField = document.querySelector('.to-field');
                const fromVal = {
                    main: fromField.querySelector('.value-main').textContent,
                    code: fromField.querySelector('.value-main').dataset.valueCode,
                    sub: fromField.querySelector('.value-sub').textContent
                };
                const toVal = {
                    main: toField.querySelector('.value-main').textContent,
                    code: toField.querySelector('.value-main').dataset.valueCode,
                    sub: toField.querySelector('.value-sub').textContent
                };
                fromField.querySelector('.value-main').textContent = toVal.main;
                fromField.querySelector('.value-main').dataset.valueCode = toVal.code;
                fromField.querySelector('.value-sub').textContent = toVal.sub;
                toField.querySelector('.value-main').textContent = fromVal.main;
                toField.querySelector('.value-main').dataset.valueCode = fromVal.code;
                toField.querySelector('.value-sub').textContent = fromVal.sub;
            });

            // --- FLATPICKR CALENDAR LOGIC (FOR THE FIRST FORM) ---
            const futureDate = new Date();
            futureDate.setDate(futureDate.getDate() + 2);
            const displayDateStr = `${futureDate.getDate()} ${futureDate.toLocaleString('default', { month: 'short' })} ${futureDate.getFullYear()}`;
            const valueDateStr = futureDate.toISOString().split('T')[0];
            document.querySelector('#journey-date-field .value-main').textContent = displayDateStr;
            document.querySelector('#journey-date-input').value = valueDateStr;
            const journeyDateField = document.querySelector('#journey-date-field');
            const returnDateField = document.querySelector('#return-date-field');
            window.journeyDatepicker = flatpickr("#journey-date-input", {
                defaultDate: valueDateStr,
                minDate: "today",
                clickOpens: false,
                positionElement: journeyDateField,
                onChange: (d, s) => {
                    if (d.length) {
                        journeyDateField.querySelector('.value-main').textContent = `${d[0].getDate()} ${d[0].toLocaleString('default', { month: 'short' })} ${d[0].getFullYear()}`;
                        if (window.returnDatepicker) window.returnDatepicker.set('minDate', s);
                    }
                }
            });
            window.returnDatepicker = flatpickr("#return-date-input", {
                minDate: valueDateStr,
                clickOpens: false,
                positionElement: returnDateField,
                onChange: (d) => {
                    if (d.length) {
                        returnDateField.querySelector('.value-main').textContent = `${d[0].getDate()} ${d[0].toLocaleString('default', { month: 'short' })} ${d[0].getFullYear()}`;
                        returnDateField.querySelector('.value-main').classList.remove('placeholder');
                    }
                }
            });

            function openCalendar(dp) {
                return (e) => {
                    e.preventDefault();
                    e.stopPropagation();
                    dp.open();
                }
            }
            journeyDateField.addEventListener('click', openCalendar(window.journeyDatepicker));
            returnDateField.addEventListener('click', openCalendar(window.returnDatepicker));

            // --- *** UNIFIED FORM SUBMISSION LOGIC *** ---
            document.getElementById('flight-search-form').addEventListener('submit', function(event) {
                event.preventDefault();
                const tripType = document.querySelector('input[name="trip-type"]:checked').value;
                const params = new URLSearchParams();
                params.append('tripType', tripType);

                // For multi-city, each leg can have different passengers/class. For one-way/return, it's global.
                if (tripType === 'one-way' || tripType === 'return') {
                    const mainForm = document.querySelector('.form-grid.trip-form');
                    const travelerField = mainForm.querySelector('.traveler-field');
                    params.append('adults', travelerField.querySelector('.pax-count-adults').textContent);
                    params.append('children', travelerField.querySelector('.pax-count-children').textContent);
                    params.append('infants', travelerField.querySelector('.pax-count-infants').textContent);
                    params.append('travelClass', travelerField.querySelector('input[name="flight-class"]:checked').value);

                    params.append('legs[0][origin]', mainForm.querySelector('.from-field .value-main').dataset.valueCode);
                    params.append('legs[0][destination]', mainForm.querySelector('.to-field .value-main').dataset.valueCode);
                    params.append('legs[0][date]', mainForm.querySelector('.journey-date-input').value);

                    if (tripType === 'return') {
                        params.append('legs[1][origin]', mainForm.querySelector('.to-field .value-main').dataset.valueCode);
                        params.append('legs[1][destination]', mainForm.querySelector('.from-field .value-main').dataset.valueCode);
                        params.append('legs[1][date]', mainForm.querySelector('.return-date-input').value);
                    }
                } else if (tripType === 'multi-city') {
                    const allTripForms = document.querySelectorAll('.trip-form');
                    allTripForms.forEach((form, index) => {
                        const fromCode = form.querySelector('.from-field .value-main').dataset.valueCode;
                        const toCode = form.querySelector('.to-field .value-main').dataset.valueCode;
                        const depDate = form.querySelector('.journey-date-input').value;
                        const travelerField = form.querySelector('.traveler-field');

                        if (fromCode && toCode && depDate && travelerField) {
                            params.append(`legs[${index}][origin]`, fromCode);
                            params.append(`legs[${index}][destination]`, toCode);
                            params.append(`legs[${index}][date]`, depDate);
                            params.append(`legs[${index}][adults]`, travelerField.querySelector('.pax-count-adults').textContent);
                            params.append(`legs[${index}][children]`, travelerField.querySelector('.pax-count-children').textContent);
                            params.append(`legs[${index}][infants]`, travelerField.querySelector('.pax-count-infants').textContent);
                            params.append(`legs[${index}][travelClass]`, travelerField.querySelector('input[name^="flight-class"]:checked').value);
                        }
                    });
                }

                const redirectUrl = `flight-search.php?${params.toString()}`;
                window.location.href = redirectUrl;
            });
        });
    </script>

</body>

</html>