<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'db-config.php';

// Security Check: If the user hasn't successfully submitted a form, redirect them away.
if (!isset($_SESSION['submission_success']) || $_SESSION['submission_success'] !== true) {
    header("Location: index.php");
    exit();
}

// ======================================================================
//  CHECK USER TYPE
// ======================================================================
$is_agent_booking = (isset($_SESSION['user_type']) && ($_SESSION['user_type'] === 'agent' || $_SESSION['user_type'] === 'admin'));

// Get common data
$customer_name = htmlspecialchars($_SESSION['success_context_name'] ?? 'Valued Customer');
$booking_type = $_SESSION['booking_type'] ?? 'general';
$show_custom_package_button = ($booking_type === 'flight');

// Initialize variables
$whatsapp_link = '';

// ======================================================================
//  DYNAMIC MESSAGE BUILDER (FOR CUSTOMERS ONLY)
// ======================================================================
if (!$is_agent_booking) {
    // Your WhatsApp Number
    $whatsapp_number = "923052394810";
    $whatsapp_message = "";

    if ($booking_type === 'umrah') {
        $package_name = $_SESSION['success_package_name'] ?? 'the selected package';
        $package_id = $_SESSION['success_package_id'] ?? 'N/A';
        $pax = $_SESSION['success_pax'] ?? 1;
        $room_type = $_SESSION['success_room_type'] ?? 'N/A';

        $whatsapp_message = "Assalam-o-Alaikum, RF Travel & Tours,\n\n";
        $whatsapp_message .= "I have just submitted an inquiry for an Umrah package on your website. Here are the details:\n\n";
        $whatsapp_message .= "Package Name: " . $package_name . "\n";
        $whatsapp_message .= "Package ID: " . $package_id . "\n";
        $whatsapp_message .= "My Name: " . $customer_name . "\n";
        $whatsapp_message .= "Number of People (Pax): " . $pax . "\n";
        $whatsapp_message .= "Room Type: " . $room_type . "\n\n";
        $whatsapp_message .= "Please confirm my inquiry and let me know the next steps.\n\n";
        $whatsapp_message .= "JazakAllah Khair.";

    } elseif ($booking_type === 'flight') {
        $booking_ref = $_SESSION['success_booking_ref'] ?? 'N/A';
        $flight_route = $_SESSION['success_flight_route'] ?? 'N/A';
        $flight_date = $_SESSION['success_flight_date'] ?? 'N/A';
        $passenger_count = $_SESSION['success_passenger_count'] ?? 1;
        
        $whatsapp_message = "Hello, RF Travel & Tours,\n\n";
        $whatsapp_message .= "I have just submitted a flight booking request on your website. Here are the details:\n\n";
        $whatsapp_message .= "Booking Reference: " . $booking_ref . "\n";
        $whatsapp_message .= "Route: " . $flight_route . "\n";
        $whatsapp_message .= $flight_date . "\n";
        $whatsapp_message .= "Total Passengers: " . $passenger_count . "\n";
        $whatsapp_message .= "Lead Passenger Name: " . $customer_name . "\n\n";
        $whatsapp_message .= "Please confirm my booking request and advise on the payment process.\n\n";
        $whatsapp_message .= "Thank you.";

    } elseif ($booking_type === 'custom_package') {
        $booking_ref = $_SESSION['success_booking_ref'] ?? 'N/A';

        $whatsapp_message = "Assalam-o-Alaikum, RF Travel & Tours,\n\n";
        $whatsapp_message .= "I have just created and submitted a custom Umrah package inquiry on your website. Here are the details:\n\n";
        $whatsapp_message .= "Booking Reference: " . $booking_ref . "\n";
        $whatsapp_message .= "My Name: " . $customer_name . "\n\n";
        $whatsapp_message .= "Please review my custom package and send me a formal quotation.\n\n";
        $whatsapp_message .= "JazakAllah Khair.";

    } else {
        // Fallback for any other type of submission
        $whatsapp_message = "Hello RF Travel & Tours, I have just submitted a request on your website. My name is " . $customer_name . ". Please get in touch with me. Thank you.";
    }

    $whatsapp_link = "https://wa.me/" . $whatsapp_number . "?text=" . urlencode($whatsapp_message);
}

// ======================================================================
//  CLEANUP SESSION (FOR ALL USERS)
// ======================================================================
unset(
    $_SESSION['submission_success'],
    $_SESSION['booking_type'],
    $_SESSION['success_context_name'],
    // Umrah variables
    $_SESSION['success_package_name'],
    $_SESSION['success_package_id'],
    $_SESSION['success_pax'],
    $_SESSION['success_room_type'],
    // Flight & Custom Package variables
    $_SESSION['success_booking_ref'],
    $_SESSION['success_flight_route'],
    $_SESSION['success_flight_date'],
    $_SESSION['success_passenger_count']
);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inquiry Received - Amere Taiba</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    
    <?php if (!$is_agent_booking): ?>
        <meta http-equiv="refresh" content="5;url=<?= htmlspecialchars($whatsapp_link) ?>">
    <?php endif; ?>
    
    <style>
        body { background-color: #f8f9fa; }
        .thank-you-container { display: flex; align-items: center; justify-content: center; min-height: 80vh; padding: 2rem; }
        .thank-you-card { background: #fff; padding: 3rem; border-radius: 16px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1); text-align: center; max-width: 600px; width: 100%; }
        .thank-you-icon { font-size: 4rem; color: #28a745; margin-bottom: 1.5rem; }
        .thank-you-card h1 { font-size: 2.5rem; color: #212529; margin-bottom: 1rem; }
        .thank-you-card p { font-size: 1.1rem; color: #6c757d; line-height: 1.6; margin-bottom: 1rem; }
        .redirect-info { margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #e9ecef; }
        .redirect-info p { font-size: 1rem; color: #555; }
        .redirect-info a { color: #31a7e2; font-weight: 600; }
        .loader {
            border: 4px solid #f3f3f3;
            border-radius: 50%;
            border-top: 4px solid #31a7e2;
            width: 40px;
            height: 40px;
            animation: spin 2s linear infinite;
            margin: 20px auto;
        }

        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }

        .custom-package-promo {
            margin: 2rem 0;
            padding: 1.5rem;
            background-color: #f0f8ff;
            border-radius: 8px;
            border: 1px solid #d1e7fd;
        }
        .custom-package-promo p {
            margin-top: 0;
            margin-bottom: 1rem;
            font-size: 1rem;
            color: #055160;
            font-weight: 500;
        }
        .btn-custom-package {
            display: inline-block;
            background-color: #0353a4;
            color: #fff;
            padding: 12px 25px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: background-color 0.3s ease;
        }
        .btn-custom-package:hover {
            background-color: #023e7d;
        }
        
        .agent-actions {
            margin-top: 2rem;
            display: flex;
            justify-content: center;
            gap: 1rem;
            flex-wrap: wrap;
        }
        .btn-action {
            display: inline-block;
            background-color: #0353a4;
            color: #fff;
            padding: 12px 25px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: background-color 0.3s ease;
        }
        .btn-action:hover {
            background-color: #023e7d;
        }
        .btn-action.secondary {
            background-color: #6c757d;
        }
        .btn-action.secondary:hover {
            background-color: #5a6268;
        }

    </style>
</head>

<body>
    <?php include 'header.php'; ?>

    <main class="thank-you-container">
        <div class="thank-you-card">

            <?php if ($is_agent_booking): ?>
                <!-- AGENT/ADMIN VIEW -->
                <div class="thank-you-icon"><i class="fas fa-check-circle"></i></div>
                <h1>Inquiry Submitted!</h1>
                <p>The inquiry for <strong><?= $customer_name ?></strong> has been successfully recorded. You can view it in the Web Inquiries section of your dashboard.</p>
                <div class="agent-actions">
                    <a href="custom-package.php" class="btn-action">
                        <i class="fas fa-plus"></i> Book Another Package
                    </a>
                    <a href="admin/dashboard.php" class="btn-action secondary">
                        <i class="fas fa-tachometer-alt"></i> Go to Dashboard
                    </a>
                </div>

            <?php else: ?>
                <!-- CUSTOMER VIEW -->
                <div class="thank-you-icon"><i class="fas fa-check-circle"></i></div>
                <h1>Thank You, <?= $customer_name ?>!</h1>
                <p>Your request has been received. We are now redirecting you to WhatsApp to confirm your details with our team.</p>
                
                <?php if ($show_custom_package_button): ?>
                <div class="custom-package-promo">
                    <p>Have your flight? Now build a complete ground package for your trip!</p>
                    <a href="custom-package.php" class="btn-custom-package">
                        <i class="fas fa-kaaba"></i> Build Your Custom Package Now
                    </a>
                </div>
                <?php endif; ?>

                <div class="loader"></div>

                <div class="redirect-info">
                    <p>
                        If you are not redirected automatically in a few seconds, 
                        <a href="<?= htmlspecialchars($whatsapp_link) ?>" target="_blank">please click here</a>.
                    </p>
                </div>
            <?php endif; ?>

        </div>
    </main>

    <?php if (file_exists('footer.php')) { include 'footer.php'; } ?>
</body>
</html>