<?php
// Start session before any output
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'db-config.php'; // This line creates the $conn variable.


$umrah_packages_grid_result = null; // Use a new variable name to avoid conflicts
try {
    // --- QUICK FIX APPLIED ---
    // Fetches the 3 most recently CREATED packages.
    // This avoids errors if 'is_active' and 'last_updated' columns don't exist.
    $sql = "SELECT * FROM umrah_packages ORDER BY created_at DESC LIMIT 3";

    $umrah_packages_grid_result = $conn->query($sql);
} catch (Exception $e) {
    // In case of a database error, the section will gracefully show the 'no packages' message.
    error_log("Failed to fetch Umrah packages for homepage grid: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RF Travel & Tours - Final Look</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">

    <!-- Link to our CSS file -->
    <link rel="stylesheet" href="css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Flatpickr CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<style>
    @media (max-width: 768px) {  /* applies only on mobile/tablet */
  .spacer {
    margin-bottom: 350px !important;
  }
}

</style>

<body>

    <?php include 'header.php'; ?>


    <main>
        <section class="hero-section spacer" >
            <div class="hero-content">
                <h1>Explore the whole world <br> and its Beauty</h1>
                <p>Explore beyond your imagination where every journey enriches the soul and creates memories that last a lifetime.</p>
            </div>

            <div class="search-container">
                <div class="tabs-wrapper">
                    <div class="service-tabs">
                        <!-- Make sure to change the href values to your actual page names -->
                        <!-- The "active" class should be on the link for the page you are currently on -->
                        <a href="index.php" class="tab"><i class="fa-solid fa-plane-up"></i> Ticket</a>
                    <a href="group-fares.php" class="tab"><i class="fa-solid fa-users"></i> Groups</a>
                    <a href="umrah-packages.php" class="tab active"><i class="fa-solid fa-kaaba"></i> Umrah</a>
                    <a href="hotels.php" class="tab"><i class="fa-solid fa-hotel"></i> Hotels</a>
                    <a href="visa-services.php" class="tab"><i class="fa-solid fa-passport"></i> Visas</a>
                    <a href="custom-package.php" class="tab"><i class="fa-solid fa-kaaba"></i> Custom Package</a>
                    </div>
                </div>

                <!-- ============================================= -->
                <!-- ===== INTERACTIVE SEARCH FORM (FINAL FIX) ===== -->
                <!-- ============================================= -->
                <!-- ============================================= -->
                <!--   SIMPLE UMRAH WELCOME BLOCK (FINAL)        -->
                <!-- ============================================= -->
<div class="search-form-wrapper">
                    <div class="umrah-welcome-text">
                        <h2>Avail Best Umrah Packages with <strong>RF Travel & Tours</strong></h2>
                        <p>We render Umrah services round the clock 24/7 and around the world.</p>
                        <p class="guarantee-line">Umrah Packages – Best Price Guarantee!</p>
                    </div>
                </div>



            </div>
        </section>





        <?php include 'all-packages.php'; ?>

        <?php include 'floating-icon.php'; ?>
        <?php include 'footer.php'; ?>



    </main>

    <!-- NEW: JavaScript for Sidebar Functionality -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const menuToggle = document.querySelector('.menu-toggle');
            const sidebarCloseBtn = document.querySelector('.sidebar-close-btn');
            const mobileSidebar = document.querySelector('.mobile-sidebar');
            const sidebarOverlay = document.querySelector('.sidebar-overlay');
            const body = document.body;

            function openSidebar() {
                mobileSidebar.classList.add('active');
                sidebarOverlay.classList.add('active');
                body.classList.add('sidebar-open');
            }

            function closeSidebar() {
                mobileSidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
                body.classList.remove('sidebar-open');
            }

            menuToggle.addEventListener('click', openSidebar);
            sidebarCloseBtn.addEventListener('click', closeSidebar);
            sidebarOverlay.addEventListener('click', closeSidebar);
        });
    </script>

    <!-- Flatpickr JS (should already be in your head or before this script) -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>


    <!-- NEW API-Integrated Form Logic -->
    <!-- This is the complete and final script for your interactive form -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {

            // =================================================================
            //  AMADEUS API LOGIC (This part is correct and unchanged)
            // =================================================================
            const AMADEUS_API_KEY = 'ODHfAdal8JCJrcFC8NGrbSnAVmCS3hMC';
            const AMADEUS_API_SECRET = '2VHNu0uaCSiGDsT4';

            let amadeusAccessToken = null;


            async function getAmadeusToken() {
                if (amadeusAccessToken) return amadeusAccessToken;
                try {
                    const response = await fetch('https://api.amadeus.com/v1/security/oauth2/token', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: `grant_type=client_credentials&client_id=${AMADEUS_API_KEY}&client_secret=${AMADEUS_API_SECRET}`
                    });
                    if (!response.ok) throw new Error('Token fetch failed');
                    const data = await response.json();
                    amadeusAccessToken = data.access_token;
                    return amadeusAccessToken;
                } catch (error) {
                    console.error("Amadeus Auth Error:", error);
                    return null;
                }
            }

            async function searchLocations(keyword) {
                const token = await getAmadeusToken();
                if (!token) return [];
                const url = `https://api.amadeus.com/v1/reference-data/locations?subType=CITY,AIRPORT&keyword=${keyword}&view=LIGHT`;
                try {
                    const response = await fetch(url, {
                        headers: {
                            'Authorization': `Bearer ${token}`
                        }
                    });
                    if (!response.ok) throw new Error('Location fetch failed');
                    const data = await response.json();
                    return data.data;
                } catch (error) {
                    console.error("Amadeus Search Error:", error);
                    return [];
                }
            }

            function debounce(func, delay) {
                let timeout;
                return function(...args) {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(this, args), delay);
                };
            }

            const handleLocationSearch = debounce(async (inputElement, resultsList) => {
                const keyword = inputElement.value;
                if (keyword.length < 2) {
                    resultsList.innerHTML = '<li>Type to search...</li>';
                    return;
                }
                resultsList.innerHTML = '<li class="loading-item">Loading...</li>';
                const locations = await searchLocations(keyword);
                resultsList.innerHTML = '';
                if (locations && locations.length > 0) {
                    locations.forEach(location => {
                        const li = document.createElement('li');
                        li.dataset.code = location.iataCode;
                        li.dataset.city = location.address.cityName;
                        li.dataset.country = location.address.countryName;
                        li.dataset.name = location.name;
                        li.innerHTML = `<strong>${location.address.cityName}</strong>, ${location.address.countryName} <span class="iata-code">${location.iataCode}</span>`;
                        resultsList.appendChild(li);
                    });
                } else {
                    resultsList.innerHTML = '<li class="no-results-item">No results found</li>';
                }
            }, 350);

            // =================================================================
            //  FORM INTERACTIVITY LOGIC (This part is correct and unchanged)
            // =================================================================

            const dropdownToggles = document.querySelectorAll('.dropdown-toggle');
            dropdownToggles.forEach(toggle => {
                toggle.addEventListener('click', (event) => {
                    if (document.querySelector('.flatpickr-calendar.open')) return;
                    const isActive = toggle.classList.contains('active');
                    document.querySelectorAll('.form-field.active').forEach(openField => openField.classList.remove('active'));
                    if (!isActive) toggle.classList.add('active');
                    event.stopPropagation();
                });
            });

            document.addEventListener('click', () => {
                document.querySelectorAll('.form-field.active').forEach(openField => openField.classList.remove('active'));
            });

            document.querySelectorAll('.dropdown-menu').forEach(menu => {
                menu.addEventListener('click', (event) => event.stopPropagation());
            });

            document.querySelectorAll('.location-dropdown input').forEach(input => {
                const resultsList = input.closest('.dropdown-menu').querySelector('ul');
                input.addEventListener('input', () => handleLocationSearch(input, resultsList));
            });

            document.querySelectorAll('.location-dropdown ul').forEach(list => {
                list.addEventListener('click', (event) => {
                    const li = event.target.closest('li');
                    if (li && li.dataset.code) {
                        const formField = li.closest('.form-field');
                        const mainDisplay = formField.querySelector('.value-main');
                        const subDisplay = formField.querySelector('.value-sub');
                        mainDisplay.textContent = li.dataset.city;
                        mainDisplay.dataset.valueCode = li.dataset.code;
                        subDisplay.textContent = `${li.dataset.country} - ${li.dataset.name}`;
                        formField.classList.remove('active');
                    }
                });
            });

            document.querySelectorAll('.btn-done').forEach(btn => {
                btn.addEventListener('click', () => {
                    btn.closest('.form-field').classList.remove('active');
                });
            });

            const passengerCounters = document.querySelectorAll('.passenger-counter');
            passengerCounters.forEach(counter => {
                const type = counter.querySelector('.counter-btn').dataset.type;
                const countSpan = document.getElementById(`${type}-count`);
                const decrementBtn = counter.querySelector('[data-action="decrement"]');
                const incrementBtn = counter.querySelector('[data-action="increment"]');
                decrementBtn.addEventListener('click', () => {
                    let count = parseInt(countSpan.textContent);
                    if (type === 'adults' && count > 1) count--;
                    else if (type !== 'adults' && count > 0) count--;
                    countSpan.textContent = count;
                    updateTravelerDisplay();
                });
                incrementBtn.addEventListener('click', () => {
                    let count = parseInt(countSpan.textContent);
                    count++;
                    countSpan.textContent = count;
                    updateTravelerDisplay();
                });
            });
            document.querySelectorAll('input[name="flight-class"]').forEach(radio => {
                radio.addEventListener('change', updateTravelerDisplay);
            });

            function updateTravelerDisplay() {
                const adults = parseInt(document.getElementById('adults-count').textContent);
                const children = parseInt(document.getElementById('children-count').textContent);
                const infants = parseInt(document.getElementById('infants-count').textContent);
                const totalTravelers = adults + children + infants;
                const selectedClass = document.querySelector('input[name="flight-class"]:checked').value;
                const mainDisplay = document.querySelector('.traveler-field .value-main');
                const subDisplay = document.querySelector('.traveler-field .value-sub');
                mainDisplay.textContent = `${totalTravelers} Traveller${totalTravelers > 1 ? 's' : ''}`;
                subDisplay.textContent = selectedClass;
            }

            const swapBtn = document.querySelector('.swap-icon');
            swapBtn.addEventListener('click', (event) => {
                event.stopPropagation();
                const fromField = document.querySelector('.from-field');
                const toField = document.querySelector('.to-field');
                const fromVal = {
                    main: fromField.querySelector('.value-main').textContent,
                    code: fromField.querySelector('.value-main').dataset.valueCode,
                    sub: fromField.querySelector('.value-sub').textContent,
                };
                const toVal = {
                    main: toField.querySelector('.value-main').textContent,
                    code: toField.querySelector('.value-main').dataset.valueCode,
                    sub: toField.querySelector('.value-sub').textContent,
                };
                fromField.querySelector('.value-main').textContent = toVal.main;
                fromField.querySelector('.value-main').dataset.valueCode = toVal.code;
                fromField.querySelector('.value-sub').textContent = toVal.sub;
                toField.querySelector('.value-main').textContent = fromVal.main;
                toField.querySelector('.value-main').dataset.valueCode = fromVal.code;
                toField.querySelector('.value-sub').textContent = fromVal.sub;
            });

            // =================================================================
            //  FLATPICKR CALENDAR LOGIC (CORRECTED)
            // =================================================================

            // 1. Calculate the date for today + 2 days
            const futureDate = new Date();
            futureDate.setDate(futureDate.getDate() + 2);

            // 2. Format the date for the visible display (e.g., "16 Jul 2025")
            const displayDateStr = `${futureDate.getDate()} ${futureDate.toLocaleString('default', { month: 'short' })} ${futureDate.getFullYear()}`;

            // 3. Format the date for the hidden input and Flatpickr (e.g., "2025-07-16")
            const valueDateStr = futureDate.toISOString().split('T')[0];

            // 4. Update the visible div and the hidden input's value
            document.querySelector('#journey-date-field .value-main').textContent = displayDateStr;
            document.querySelector('#journey-date-input').value = valueDateStr;


            // =================================================================
            //  FLATPICKR CALENDAR LOGIC (UPDATED)
            // =================================================================



            // --- 2. Initialize Calendars (With the best option from your old setup) ---
            const journeyDateField = document.querySelector('#journey-date-field');
            const returnDateField = document.querySelector('#return-date-field');

            // Attach to window object so they are globally accessible if needed
            window.journeyDatepicker = flatpickr("#journey-date-input", {
                defaultDate: valueDateStr,
                minDate: "today",
                clickOpens: false,
                positionElement: journeyDateField,
                disableMobile: true, // <-- This is your excellent idea for a better mobile UX.
                onChange: function(selectedDates, dateStr, instance) {
                    if (selectedDates.length === 0) return;
                    const display = journeyDateField.querySelector('.value-main');
                    const d = selectedDates[0];
                    display.textContent = `${d.getDate()} ${d.toLocaleString('default', { month: 'short' })} ${d.getFullYear()}`;
                    if (window.returnDatepicker) {
                        window.returnDatepicker.set('minDate', dateStr);
                    }
                }
            });

            window.returnDatepicker = flatpickr("#return-date-input", {
                minDate: valueDateStr,
                clickOpens: false,
                positionElement: returnDateField,
                disableMobile: true,
                onChange: function(selectedDates, dateStr, instance) {
                    if (selectedDates.length === 0) return;
                    const display = returnDateField.querySelector('.value-main');
                    const d = selectedDates[0];
                    display.textContent = `${d.getDate()} ${d.toLocaleString('default', { month: 'short' })} ${d.getFullYear()}`;
                }
            });


            // --- 3. THE DEFINITIVE FIX: Robust Click/Tap Listeners ---
            // A reusable function to open a calendar reliably
            function openCalendar(datepickerInstance) {
                return function(event) {
                    // STOPS the browser from trying to scroll or zoom on tap
                    event.preventDefault();
                    // STOPS the tap from being "eaten" or cancelled by other scripts
                    event.stopPropagation();

                    // It's good practice to close other menus first.
                    // Ensure you have a 'closeAllPopups' function defined.
                    if (typeof closeAllPopups === 'function') {
                        closeAllPopups();
                    }

                    // FINALLY, open the calendar
                    datepickerInstance.open();
                }
            }
            // This is our single, smart function for handling calendar opening/closing.
            function handleCalendarToggle(datepickerInstance) {
                return function(event) {
                    event.preventDefault(); // For touchstart
                    event.stopPropagation(); // Stop click from bubbling up to document

                    // --- THE CORE LOGIC ---
                    // 1. Check if the calendar we are trying to open is ALREADY the one that is open.
                    const isAlreadyOpen = datepickerInstance.isOpen;

                    // 2. No matter what, close everything first. This guarantees a clean slate
                    //    and prevents calendars from stacking up.
                    closeAllPopups();

                    // 3. If the calendar we tapped WAS NOT already open, open it now.
                    //    If it WAS open, the step above already closed it, so we do nothing.
                    if (!isAlreadyOpen) {
                        datepickerInstance.open();
                    }
                }
            }



            // --- 5. Global "Click Outside" Listener ---
            // This is what closes a popup when you tap anywhere else on the page.
            document.addEventListener('click', (event) => {
                closeAllPopups();
            });

            // --- 6. Prevent Clicks Inside a Dropdown Menu from Closing It ---
            document.querySelectorAll('.dropdown-menu').forEach(menu => {
                menu.addEventListener('click', (event) => event.stopPropagation());
            });

            // Attach the reliable handler to BOTH `click` (for desktop) and `touchstart` (for mobile)
            journeyDateField.addEventListener('click', openCalendar(window.journeyDatepicker));
            journeyDateField.addEventListener('touchstart', openCalendar(window.journeyDatepicker), {
                passive: false
            });

            returnDateField.addEventListener('click', openCalendar(window.returnDatepicker));
            returnDateField.addEventListener('touchstart', openCalendar(window.returnDatepicker), {
                passive: false
            });

            // Helper function to close everything
            function closeAllPopups() {
                // You must have this function defined earlier in your script.
                // It should close all dropdowns and all calendars.
                document.querySelectorAll('.form-field.active').forEach(field => field.classList.remove('active'));
                if (window.journeyDatepicker && window.journeyDatepicker.isOpen) window.journeyDatepicker.close();
                if (window.returnDatepicker && window.returnDatepicker.isOpen) window.returnDatepicker.close();
            }

            // --- Global "Click Outside" Listener ---
            document.addEventListener('click', (event) => {
                closeAllPopups();
            });

            // --- Prevent Clicks Inside a Dropdown Menu from Closing It ---
            document.querySelectorAll('.dropdown-menu').forEach(menu => {
                menu.addEventListener('click', (event) => event.stopPropagation());
            });

            // =================================================================
            //  FORM SUBMISSION LOGIC (This part is correct and unchanged)
            // =================================================================

            // =================================================================
            //  FORM SUBMISSION & REDIRECT LOGIC (THIS IS THE MODIFIED PART)
            // =================================================================
            const flightForm = document.getElementById('flight-search-form');

            flightForm.addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent the default form submission

                // 1. Collect all the data from the form (your existing code, which is correct)
                const searchData = {
                    from: {
                        code: document.querySelector('.from-field .value-main').dataset.valueCode,
                        name: document.querySelector('.from-field .value-main').textContent
                    },
                    to: {
                        code: document.querySelector('.to-field .value-main').dataset.valueCode,
                        name: document.querySelector('.to-field .value-main').textContent
                    },
                    journeyDate: journeyDatepicker.selectedDates[0] ? journeyDatepicker.selectedDates[0].toISOString().split('T')[0] : null,
                    returnDate: returnDatepicker.selectedDates[0] ? returnDatepicker.selectedDates[0].toISOString().split('T')[0] : null,
                    passengers: {
                        adults: document.getElementById('adults-count').textContent,
                        children: document.getElementById('children-count').textContent,
                        infants: document.getElementById('infants-count').textContent
                    },
                    class: document.querySelector('input[name="flight-class"]:checked').value
                };

                // --- NEW: Build the URL for the PHP results page ---

                // 2. Create a URLSearchParams object to safely build the query string.
                // This automatically handles encoding and makes the code cleaner.
                const params = new URLSearchParams();

                // 3. Add parameters that match what your PHP script expects in $_GET
                params.append('fly_from', searchData.from.code);
                params.append('fly_to', searchData.to.code);
                params.append('departure_date', searchData.journeyDate);

                // Only add the return date if it exists
                if (searchData.returnDate) {
                    params.append('return_date', searchData.returnDate);
                }

                params.append('adults', searchData.passengers.adults);
                params.append('children', searchData.passengers.children);
                params.append('infants', searchData.passengers.infants);

                // NOTE: Your PHP script doesn't currently use 'travelClass' or 'currency' from the initial search,
                // but we can pass them in case you add that logic later. The PHP script will safely ignore them if not used.
                params.append('travelClass', searchData.class);
                // If you add a currency selector to your search form with id="currency-selector", you can uncomment this line:
                // params.append('currency', document.getElementById('currency-selector').value);


                // 4. Construct the final URL
                const redirectUrl = `flight-search.php?${params.toString()}`;

                // 5. Log for debugging and then redirect the user
                console.log("Redirecting to:", redirectUrl);
                window.location.href = redirectUrl;
            });
        });
    </script>

</body>

</html>