<?php
require_once 'db-config.php';

function e($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// Fetch all settings for the rate list design
$settings_result = $conn->query("SELECT setting_key, setting_value FROM custom_package_settings WHERE setting_key LIKE 'rate_list_%'");
$settings = [];
while($row = $settings_result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Set default values if not found in DB
$defaults = [
    'rate_list_logo' => 'images/logo.png',
    'rate_list_main_title' => 'UMRAH 1447-H',
    'rate_list_subtitle' => 'AVIATION - HAJJ - UMRAH - TOURS',
    'rate_list_vouchers_from' => '15 SEP, 2025',
    'rate_list_check_till' => '15 NOV, 2025',
    'rate_list_instructions' => "Rates are subject to availability...\nRates can be changed without Prior Notice...\nAny Tax/Fee by KSA will be charged...\nVisa & Voucher Payment 100% in Advance.",
    'rate_list_header_bg' => '#b91c1c',
    'rate_list_header_text' => '#ffffff',
    'rate_list_table_header_bg' => '#333333',
    'rate_list_table_header_text' => '#ffffff',
    'rate_list_accent_color' => '#b91c1c',
    'rate_list_font' => 'Poppins',
];
$settings = array_merge($defaults, $settings);

// Fetch Hotel Data
$all_hotels_result = $conn->query("SELECT * FROM custom_package_hotel_rates ORDER BY city, hotel_name");
$makkah_hotels_data = [];
$madinah_hotels_data = [];
if ($all_hotels_result) {
    while ($hotel = $all_hotels_result->fetch_assoc()) {
        if ($hotel['city'] === 'Makkah') $makkah_hotels_data[] = $hotel;
        elseif ($hotel['city'] === 'Madinah') $madinah_hotels_data[] = $hotel;
    }
}

function generateHotelTable($title, $hotels) {
    if (empty($hotels)) return '';
    $rows = '';
    foreach($hotels as $hotel) {
        $rows .= sprintf(
            '<tr><td>%s<span class="notes">%s</span></td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>',
            e($hotel['hotel_name']), e($hotel['notes']), e($hotel['star_rating']), e($hotel['distance_info']),
            $hotel['rate_sharing'] ? number_format($hotel['rate_sharing'], 0) : 'N/A',
            $hotel['rate_quad'] ? number_format($hotel['rate_quad'], 0) : 'N/A',
            $hotel['rate_trpl'] ? number_format($hotel['rate_trpl'], 0) : 'N/A',
            $hotel['rate_dubl'] ? number_format($hotel['rate_dubl'], 0) : 'N/A'
        );
    }
    return <<<HTML
        <table class="rl-table">
            <thead>
                <tr class="city-header"><td colspan="7">{$title}</td></tr>
                <tr><th>HOTELS</th><th>STAR</th><th>DISTANCE</th><th>SHARING</th><th>QUAD</th><th>TRIPLE</th><th>DOUBLE</th></tr>
            </thead>
            <tbody>{$rows}</tbody>
        </table>
    HTML;
}

$instructions_html = '';
$instructions_array = explode("\n", $settings['rate_list_instructions']);
foreach ($instructions_array as $line) {
    if (trim($line)) {
        $instructions_html .= '<li>' . e(trim($line)) . '</li>';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hotel Rate List</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=<?= urlencode($settings['rate_list_font']) ?>:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body { margin: 0; padding: 20px; background-color: #f0f0f0; font-family: '<?= $settings['rate_list_font'] ?>', sans-serif; }
        .download-button { position: fixed; top: 20px; right: 20px; background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; box-shadow: 0 2px 5px rgba(0,0,0,0.2); z-index: 100; }
        #rate-list-content { background: white; padding: 30px; max-width: 900px; margin: auto; box-shadow: 0 10px 25px rgba(0,0,0,0.1); border: 1px solid #ddd; }
        .rl-header { background-color: <?= e($settings['rate_list_header_bg']) ?>; color: <?= e($settings['rate_list_header_text']) ?>; padding: 25px; text-align: center; border-bottom: 5px solid <?= e($settings['rate_list_accent_color']) ?>; }
        .rl-header img { max-width: 180px; margin-bottom: 15px; }
        .rl-header h1 { margin: 0; font-size: 32px; font-weight: 700; letter-spacing: 1px; }
        .rl-header p { margin: 5px 0 0; font-size: 14px; opacity: 0.9; }
        .rl-dates { display: flex; justify-content: space-between; padding: 10px 25px; background: #f7f7f7; border-bottom: 1px solid #eee; }
        .rl-date-box { text-align: center; }
        .rl-date-box span { font-size: 12px; color: #555; }
        .rl-date-box h4 { margin: 4px 0 0; font-size: 16px; font-weight: 700; color: <?= e($settings['rate_list_accent_color']) ?>; }
        .rl-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .rl-table th, .rl-table td { border: 1px solid #e5e5e5; padding: 12px; text-align: center; font-size: 14px; }
        .rl-table th { background-color: <?= e($settings['rate_list_table_header_bg']) ?>; color: <?= e($settings['rate_list_table_header_text']) ?>; font-weight: 700; }
        .rl-table .city-header td { background-color: #f2f2f2; color: #333; font-weight: bold; text-align: left; font-size: 16px; padding: 15px; }
        .rl-table td:first-child { text-align: left; font-weight: 500; width: 35%; }
        .rl-table .notes { font-size: 12px; color: #666; display: block; }
        .rl-footer { margin-top: 25px; padding: 20px; border-top: 2px solid #eee; }
        .rl-footer h3 { font-size: 16px; color: <?= e($settings['rate_list_accent_color']) ?>; margin: 0 0 10px; }
        .rl-footer ul { list-style: none; padding: 0; margin: 0 0 15px 0; }
        .rl-footer li { font-size: 12px; color: #444; margin-bottom: 5px; padding-left: 15px; position: relative; }
        .rl-footer li::before { content: '✔'; position: absolute; left: 0; color: <?= e($settings['rate_list_accent_color']) ?>; }
        .rl-footer .publish-date { font-size: 11px; color: #888; text-align: right; }
        @media print { body { padding: 0; background: #fff; } .download-button { display: none; } }
    </style>
</head>
<body>
    <button id="download-btn" class="download-button">Download as JPG</button>
    <div id="rate-list-content">
        <div class="rl-header">
            <img src="<?= e($settings['rate_list_logo']) ?>" alt="Company Logo">
            <h1><?= e($settings['rate_list_main_title']) ?></h1>
            <p><?= e($settings['rate_list_subtitle']) ?></p>
        </div>
        <div class="rl-dates">
            <div class="rl-date-box"><span>VOUCHERS FROM</span><h4><?= e($settings['rate_list_vouchers_from']) ?></h4></div>
            <div class="rl-date-box"><span>CHECK TILL</span><h4><?= e($settings['rate_list_check_till']) ?></h4></div>
        </div>
        <?= generateHotelTable('MAKKAH HOTELS', $makkah_hotels_data) ?>
        <?= generateHotelTable('MADINAH HOTELS', $madinah_hotels_data) ?>
        <div class="rl-footer">
            <h3>INSTRUCTIONS</h3>
            <ul><?= $instructions_html ?></ul>
            <p class="publish-date">Published: <?= date('d M, Y') ?></p>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script>
        document.getElementById('download-btn').addEventListener('click', function() {
            const content = document.getElementById('rate-list-content');
            this.textContent = 'Generating...';
            this.disabled = true;

            html2canvas(content, { scale: 2.5, useCORS: true }).then(canvas => {
                const link = document.createElement('a');
                link.download = 'hotel-rate-list-<?= date("Y-m-d") ?>.jpg';
                link.href = canvas.toDataURL('image/jpeg', 0.95);
                link.click();
                this.textContent = 'Download as JPG';
                this.disabled = false;
            });
        });
    </script>
</body>
</html>