<!-- ============================================= -->
<!-- ===== VISA SERVICES SECTION (V2 DESIGN) ===== -->
<!-- ============================================= -->
<section class="visa-services-section" style="background-color: white;">
    <div class="listings-container">
        <!-- Reusing the header structure for consistency -->
        <div class="listings-header">
            <div class="listings-header-text">
                <h2 class="listings-title">Visa Services</h2>
                <p class="listings-subtitle">Hassle-free visa processing for top destinations worldwide.</p>
            </div>
            <a href="visa-services.php" class="btn-view-more">See All Countries</a>
        </div>

        <div class="visa-grid">
            <?php
            // --- PHP LOGIC TO FETCH VISA DATA ---
            $whatsapp_number = "923052394810";
            $sql_visas = "SELECT * FROM visas WHERE is_active = 1 ORDER BY id DESC LIMIT 3";
            $visas_result = $conn->query($sql_visas);

            if ($visas_result && $visas_result->num_rows > 0):
                while ($visa = $visas_result->fetch_assoc()):

                    // --- Logic to determine the correct link URL ---
                    $link_url = '#';
                    $button_text = 'View Details';
                    $link_target = '_self';

                    if (!empty($visa['page_link'])) {
                        $link_url = htmlspecialchars($visa['page_link']) . '.php';
                    } else {
                        $whatsapp_message = "Hi, I'm interested in the '" . $visa['visa_name'] . "' visa.";
                        $link_url = "https://wa.me/{$whatsapp_number}?text=" . urlencode($whatsapp_message);
                        $button_text = 'Apply Now';
                        $link_target = '_blank';
                    }
                    
                    // --- NEW PRICING LOGIC ---
                    // 1. Determine the base price in SAR (agent or customer)
                    $sar_price_to_show = null;
                    // This assumes $is_agent is defined earlier on your index page. If not, it will safely default to the public price.
                    if (isset($is_agent) && $is_agent && !empty($visa['price_agent'])) {
                        $sar_price_to_show = $visa['price_agent'];
                    } elseif (!empty($visa['price'])) {
                        $sar_price_to_show = $visa['price'];
                    }

                    // 2. Convert to PKR using the specific exchange rate for this visa
                    $pkr_price_to_show = null;
                    if ($sar_price_to_show && !empty($visa['exchange_rate'])) {
                        $pkr_price_to_show = $sar_price_to_show * $visa['exchange_rate'];
                    }

            ?>

                    <!-- DYNAMIC V2 Visa Card (This block will repeat for each visa) -->
                    <div class="visa-card-v2">
                        <div class="card-v2-banner">
                            <div class="card-v2-logo-overlay <?= $logo_style_class ?? 'white-bg-logo' ?>">
                                <img src="<?= htmlspecialchars($footer_logo ?? 'images/logo.png') ?>" alt="Agency Logo" crossorigin="anonymous">
                            </div>

                            <?php if (!empty($visa['city'])): ?>
                                <div class="card-v2-city-badge"><?= htmlspecialchars($visa['city']) ?></div>
                            <?php endif; ?>

                            <img src="<?= htmlspecialchars($visa['image_url'] ?: 'images/default-visa.jpg') ?>" alt="<?= htmlspecialchars($visa['image_alt']) ?>" class="card-v2-image" loading="lazy" crossorigin="anonymous">
                        </div>
                        <div class="card-v2-content">
                            <h3 class="visa-name-v2"><?= htmlspecialchars($visa['visa_name']) ?></h3>
                            <p class="visa-type-v2"><?= htmlspecialchars($visa['visa_type']) ?></p>
                            
                            <div class="visa-details-grid">
                                <?php if (!empty($visa['processing_time'])): ?>
                                    <div class="detail-item-v2"><i class="fas fa-hourglass-start"></i> <span><?= htmlspecialchars($visa['processing_time']) ?></span></div>
                                <?php endif; ?>
                                <?php if (!empty($visa['entry_type'])): ?>
                                    <div class="detail-item-v2"><i class="fas fa-right-to-bracket"></i> <span><?= htmlspecialchars($visa['entry_type']) ?></span></div>
                                <?php endif; ?>
                            </div>

                            <div class="visa-price-v2">
                                <?php if ($pkr_price_to_show): ?>
                                    <span><?= htmlspecialchars($visa['price_note'] ?: 'Starts From') ?></span>
                                    <strong>PKR <?= number_format($pkr_price_to_show, 0) ?></strong>
                                <?php else: ?>
                                    <span>Price</span>
                                    <strong>On Request</strong>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-v2-actions homepage-card-actions">
                            <a href="<?= $link_url ?>" target="<?= $link_target ?>" class="btn-view-deal"><?= $button_text ?></a>
                        </div>
                    </div>

            <?php
                endwhile;
            else:
            // Optional: Message if no visas are found
            // echo "<p>No visa services are currently available.</p>";
            endif;
            ?>

            <!-- View More Card (ONLY visible on mobile) -->
            <a href="visa-services.php" class="view-more-card">
                <span>See All Countries</span>
                <i class="fa-solid fa-arrow-right"></i>
            </a>
        </div>
    </div>
</section>

<style>
/*
======================================================
--- Visa Services Section Styles (Homepage V2) ---
======================================================
*/

.visa-services-section {
    padding: 4rem 0;
}

.visa-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 2rem;
}

/* --- V2 Visible Card Styling (Copied from visa-services.php for consistency) --- */
.visa-card-v2 { background: #fff; border-radius: 12px; box-shadow: 0 8px 25px rgba(0,0,0,0.08); overflow: hidden; display: flex; flex-direction: column; transition: transform 0.3s, box-shadow 0.3s; }
.visa-card-v2:hover { transform: translateY(-8px); box-shadow: 0 12px 35px rgba(0,0,0,0.12); }
.card-v2-banner { position: relative; }
.card-v2-image { display: block; width: 100%; height: 220px; object-fit: cover; }
.card-v2-logo-overlay { position: absolute; top: 15px; left: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; }
.card-v2-logo-overlay.white-bg-logo { background: rgba(255,255,255,0.85); backdrop-filter: blur(5px); border-radius: 50%; padding: 6px; box-shadow: 0 1px 5px rgba(0,0,0,0.15); }
.card-v2-logo-overlay img { max-width: 100%; max-height: 100%; object-fit: contain; }
.card-v2-city-badge { position: absolute; bottom: 15px; right: 15px; background: var(--primary-color); color: #fff; padding: 5px 12px; border-radius: 20px; font-size: 0.8rem; font-weight: 600; box-shadow: 0 2px 6px rgba(0,0,0,0.25); }
.card-v2-content { padding: 1.25rem; display: flex; flex-direction: column; flex-grow: 1; }
.visa-name-v2 { font-size: 1.4rem; font-weight: 600; color: var(--text-dark); margin: 0 0 0.25rem 0; }
.visa-type-v2 { font-size: 1rem; color: #7f8c8d; margin-bottom: 1rem; }
.visa-details-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem; font-size: 0.9rem; color: #555; }
.detail-item-v2 { display: flex; align-items: center; gap: 8px; }
.detail-item-v2 i { color: var(--primary-gold); }
.visa-price-v2 { text-align: right; margin-top: auto; padding-top: 1rem; border-top: 1px solid #f0f0f1; }
.visa-price-v2 span { font-size: 0.9rem; color: #777; display: block; margin-bottom: 2px; }
.visa-price-v2 strong { font-size: 1.6rem; font-weight: 700; color: var(--primary-color); }
.card-v2-actions { display: grid; gap: 0.75rem; padding: 1rem; background-color: #f8f9fa; }

/* Special rule for homepage cards to have a single, full-width button */
.homepage-card-actions {
    grid-template-columns: 1fr;
}
.homepage-card-actions .btn-view-deal {
    width: 100%; /* Ensure button fills the container */
}


/* --- Responsive Styles for Visa Services Section --- */
@media (max-width: 992px) {
    .visa-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .visa-services-section {
        padding: 3rem 0;
    }
    .visa-grid {
        display: flex;
        overflow-x: auto;
        gap: 1rem;
        padding: 0.5rem 1rem 1rem 1rem;
        flex-wrap: nowrap;
        scroll-snap-type: x mandatory;
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
    .visa-grid::-webkit-scrollbar {
        display: none;
    }
    .visa-card-v2 {
        flex: 0 0 85%;
        max-width: 320px;
        scroll-snap-align: start;
    }
    .visa-grid .view-more-card {
        display: flex;
    }
}
</style>